/*
 * TIFF Library
 *
 * Written by Conrad J. Poelman, PL/WSAT, Kirtland AFB, NM on 26 Mar 96.
 *
 */

/*  changes      :
		1997/11/02   by Hans Eckardt:
		           - extracted from conrads contribution
				   - added comments below
				   - Macros for DLL interface
 */


typedef struct _TIFFImageIter TIFFImageIter;

/* HE: The callback function is called for each "block" of image pixel data after
   it has been read from the file and decoded. This image pixel data is in the
   buffer pp, and this data represents the image pixels from (x,y) to
   (x+w,y+h). It is stored in pixel format, so each pixel contains
   img->samplesperpixel consecutive samples each containing img->bitspersample
   bits of data. The array pp is ordered in h consecutive rows of w+fromskew
   pixels each. */

   /* Note on parameters:
    TIFFImageIter* img - the image iterator object
    void* user_data    - user data needed for putting the image to the output format
    uint32 x, uint32 y - start point of image data; (0,0) is left bottom
    uint32 w, uint32 h - width and height of pixel tile
    int32 fromskew     - skew in pixels for the array, fromskew is w + gap
	                     where gap is ununsed pixel data
    u_char* pp         - pixel data, as above stated:

  [SAMPLEx] - consists of bitspersample bits
  [	[SAMPLE0][SAPMLE1]..[SAMPLEn] ] - a pixel of samples, consists of contiguous bits

  Example Sample RGBA
  [R - 8Bits][G - 8Bits][B - 8Bits][A - 8Bits]

  Example Sample RGB
  [R - 8Bits][G - 8Bits][B - 8Bits]

  Example Gray8
  [Gray 8Bits]

  Example Gray16
  [Gray 16Bits]

  What the callback function must do is to pickle the bits from the array given
  by the iterator and convert/store it in the structure needed for further
  processing.

  Hard parts are ...

  a) when we have (bitspersample % 8) != 0 cases
  As you see there are special cases for pickling the right bits of the byte stream
  Example Sample RGB
  [R - 4Bits][G - 4Bits][B - 4Bits]

  b) when we have palette images
	  Example Palette 16 Entries
	  [4Bit]

	  Example Palette 256 Entries
	  [8Bit]

  The callback routine setup must set the appropriate callback for 
  all these cases we want to handle
 */ 
typedef	TIFMETHOD(void , TIFFImageIterTileContigRoutine, (TIFFImageIter*, 
					void *, uint32, uint32, uint32, uint32, int32, unsigned char*));
#define	DECLAREContigCallbackFunc(name) \
static void __stdcall name(\
    TIFFImageIter* img, \
    void* user_data, \
    uint32 x, uint32 y, \
    uint32 w, uint32 h, \
    int32 fromskew, \
    u_char* src_p \
)

typedef	TIFMETHOD(void , TIFFImageIterTileSeparateRoutine, (TIFFImageIter*, 
					void *, uint32, uint32, uint32, uint32, int32,
					unsigned char*, unsigned char*, unsigned char*, unsigned char*));
#define	DECLARESepCallbackFunc(name) \
static void __stdcall name(\
    TIFFImageIter* img, \
    void* user_data, \
    uint32 x, uint32 y, \
    uint32 w, uint32 h,\
    int32 fromskew, \
    u_char* src_r_p, u_char* src_g_p, u_char* src_b_p, u_char* src_alpha_p \
)

struct _TIFFImageIter {
	TIFF*	tif;				/* image handle */
	int	stoponerr;			/* stop on read error */
	int	isContig;			/* data is packed/separate */
	int	alpha;				/* type of alpha data present */
	uint32	width;				/* image width */
	uint32	height;				/* image height */
	uint16	bitspersample;			/* image bits/sample */
	uint16	samplesperpixel;		/* image samples/pixel */
	uint16	orientation;			/* image orientation */
	uint16	photometric;			/* image photometric interp */
	uint16*	redcmap;			/* colormap pallete */
	uint16*	greencmap;
	uint16*	bluecmap;
						/* get image data routine */
	int	(*get)(TIFFImageIter*, void *udata, uint32, uint32);
	union {
	    void (*any)(TIFFImageIter*);
	    TIFFImageIterTileContigRoutine		contig;
	    TIFFImageIterTileSeparateRoutine	separate;
	} callback;				/* fn to exec for each block */
};

TIFF_DLLINTERFACE(int)
TIFFImageIterBegin(TIFFImageIter * img, TIFF * tif, int stop, char emsg[1024]);

TIFF_DLLINTERFACE(void)
TIFFImageIterEnd(TIFFImageIter * img);

TIFF_DLLINTERFACE(int)
TIFFImageIterGet(TIFFImageIter* img, void *udata, uint32 w, uint32 h);
