[Note:

	This header is actually an extract of our changed tiffio.h,
	where we have all definitions for building a DLL 
	version of the TIFF lib.

	The macros are defined as following

#ifdef BUILD_TIFF_DLL
/* a definition of an exported function in the interface: */
#define TIFF_DLLINTERFACE(type)		__declspec(dllexport) type __stdcall
#else
/* a reference to a exported function in the interface: */
#define TIFF_DLLINTERFACE(type)		__declspec(dllimport) type __stdcall
#endif

	If you do not want a DLL build or use the old style DEF file,
	simply declare the macros as

#define TIFF_DLLINTERFACE(type)	type
 
]

#ifdef TIF_WIN32_DIB_SUPPORT

/* in tif_output.c: */
#define TIFDIB_PALETTE_BW   1  // Palette with two colors
#define TIFDIB_PALETTE_16   2  // Palette with 16 colors
#define TIFDIB_PALETTE_256  3  // Palette with 256 colors
#define TIFDIB_RGB555       4  // 15bit RGB
#define TIFDIB_RGB565       5  // 16bit RGB
#define TIFDIB_RGB888       6  // 24bit RGB

TIFF_DLLINTERFACE(int)
TIFFReadDIBImage(TIFF*, BITMAPINFOHEADER*, BYTE*, int);

TIFF_DLLINTERFACE(int)
TIFFDIBGetFormat(TIFF*, int*, int*, char [1024]);

TIFF_DLLINTERFACE(int)
TIFFDIBImageOK(TIFF*, int, char [1024]);

#endif /* #ifdef TIF_WIN32_DIB_SUPPORT */


#ifdef TIF_RGBA_SUPPORT
/*
 * RGBA-style image support.
 */
typedef	unsigned char TIFFRGBValue;		/* 8-bit samples */

/*
 * Macros for extracting components from the
 * packed ABGR form returned by TIFFReadRGBAImage.
 */
#define	TIFFGetR(abgr)	((abgr) & 0xff)
#define	TIFFGetG(abgr)	(((abgr) >> 8) & 0xff)
#define	TIFFGetB(abgr)	(((abgr) >> 16) & 0xff)
#define	TIFFGetA(abgr)	(((abgr) >> 24) & 0xff)

TIFF_DLLINTERFACE(int)
TIFFReadRGBAImage(TIFF*, uint32, uint32, uint32*, int);

TIFF_DLLINTERFACE(int)
TIFFRGBAImageOK(TIFF*, char [1024]);

#endif /* #ifdef TIF_RGBA_SUPPORT */
