dnl  SGI_EXPAND_PATHS
dnl  
dnl  In various files which have paths substituted by autoconf (man pages,
dnl  RPM spec files, source files), @bindir@ gets replaced with ${prefix}/bin
dnl  rather than /usr/local/bin (for example), which is not what we want!
dnl  This performs variable expansion in @bindir@, @sbindir@, etc.
dnl  
AC_DEFUN(SGI_EXPAND_PATHS, [
    test "x$prefix" = xNONE && prefix=$ac_default_prefix
    test "x$exec_prefix" = xNONE && exec_prefix=$prefix
    list='bindir sbindir libexecdir datadir sysconfdir sharedstatedir localstatedir libdir infodir mandir includedir'; for var in $list; do
        val=`eval echo \\${$var}`
#        echo "$var == $val"
        export $var=`eval echo $val`
        val=`eval echo \\${$var}`
#        echo "  now $var == $val"
    done

dnl  This was commented out because it didn't work.  Regardless of what we
dnl  did here, automake was sticking its own values into the Makefile.in,
dnl  and it seemed too risky to hope the two definitions never got out of
dnl  whack.
dnl     #  Now automake's variables.  This is suspicious because we pretend to
dnl     #  know what values automake is going to put in the Makefile.in.
dnl     pkgdatadir=$datadir/$PACKAGE
dnl     pkglibdir=$libdir/$PACKAGE
dnl     pkgincludedir=$includedir/$PACKAGE
dnl     AC_SUBST(pkgdatadir)
dnl     AC_SUBST(pkglibdir)
dnl     AC_SUBST(pkgincludedir)

])


dnl  SGI_OUTPUT_GMAKE
dnl  
dnl  This adds #!gmake as the first line of each Makefile in AC_OUTPUT.  This
dnl  is necessary on IRIX for using gmake instead of smake/pmake/etc., which
dnl  will croak on the gmake Makefiles.
dnl  
AC_DEFUN(SGI_OUTPUT_GMAKE, [
    AC_REQUIRE([AC_CANONICAL_HOST])dnl
    AC_OUTPUT_COMMANDS([
        case "$host" in
            *-sgi-irix*)
                TMPFILE=configure.tmp
                for f in $CONFIG_FILES; do
                    if test `basename $f` != 'Makefile'; then
#                        echo "skipping        $f"
                        continue
                    fi
                    echo "adding #!gmake to $f"
                    if test -s $TMPFILE; then
                        echo "gahh, file $TMPFILE already exists"
                        exit 1
                    fi
                    mv $f $TMPFILE
                    echo '#!gmake' > $f
                    cat $TMPFILE >> $f
                    rm $TMPFILE
                done
                ;;
            *)
                ;;
        esac
    ], [host=$host])
])


dnl  SGI_PROG_GNU_TAR
dnl  
dnl  autoconf/automake expects GNU tar, so find it on IRIX.  This calls
dnl  AC_PATH_PROG(TAR).
dnl  
AC_DEFUN(SGI_PROG_GNU_TAR, [
    AC_PATH_PROG(TAR, tar, tar, /usr/freeware/bin:$PATH)
])


dnl  SGI_PROG_CC
dnl  
dnl  This attempts to use SGI compilers instead of GNU compilers by default
dnl  on IRIX.  Or maybe it doesn't.  You can override this by setting your
dnl  CC environment variable; it adds an AC_ARG_WITH which says so.
dnl  
AC_DEFUN(SGI_PROG_CC, [
    AC_REQUIRE([AC_CANONICAL_HOST])dnl
    dnl  This is sort of a perversion of the AC_ARGS_WITH macro, but I want
    dnl  ./configure --help to tell people they can set CC.
    AC_ARG_WITH(CC, [  --with-CC=cc            use the given C compiler.], [CC=$withval])
    case "$host" in
        *-sgi-irix*)
            AC_PATH_PROG(CC, cc)
            ;;
        *)
            ;;
    esac
    AC_PROG_CC
])


dnl  SGI_PROG_CXX
dnl  
dnl  This attempts to use SGI compilers instead of GNU compilers by default
dnl  on IRIX.  Or maybe it doesn't.  You can override this by setting your
dnl  CXX environment variable; it adds an AC_ARG_WITH which says so.
dnl  
AC_DEFUN(SGI_PROG_CXX, [
    AC_REQUIRE([AC_CANONICAL_HOST])dnl
    dnl  This is sort of a perversion of the AC_ARGS_WITH macro, but I want
    dnl  ./configure --help to tell people they can set CXX.
    AC_ARG_WITH(CXX, [  --with-CXX=CC           use the given C++ compiler.], [CXX=$withval])
    case "$host" in
        *-sgi-irix*)
            AC_PATH_PROG(CXX, CC)
            ;;
        *)
            ;;
    esac
    AC_PROG_CXX
])


dnl  SGI_PATH_RHINOPROG(PROG, prog)
dnl  
dnl  The difference between this and AC_PATH_PROG is that it attempts to
dnl  use a copy of the program from the current source tree rather than
dnl  an installed program.  This is complicated a bit because the version
dnl  in the source tree probably hasn't been built yet!
dnl  
dnl  To have this set FOO to $(top_srcdir)/util/foo/foo if
dnl  util/foo/foo.sh.in is found, call this with (FOO, foo).
dnl  
AC_DEFUN(SGI_PATH_RHINOPROG, [
    AC_REQUIRE([SGI_PATH_RHINO])dnl

    if eval "test \"`echo '$''{'$1'+set}'`\" = set"; then
        dnl  It's set as an environment variable, so let AC_PATH_PROG use
        dnl  that value.
        AC_PATH_PROG($1, $2)
    else
        glob=`ls util/$2/$2* 2> /dev/null`
        if test -n "$glob"; then
            dnl  It look like it might exist in the source tree at some point!
            AC_MSG_CHECKING("for $2...")
            [$1]=\$\(top_srcdir\)/util/$2/$2
            AC_MSG_RESULT(`eval echo \\${$1}`)
        else
            AC_PATH_PROG($1, $2, die, $RHBINDIR:$PATH)
            if test `eval echo \\${$1}` = "die"; then
                AC_MSG_ERROR([Didn't find $2 in util/$2 or $RHBINDIR:$PATH])
            fi
        fi
    fi
])


dnl  SGI_PROG_MKPRIVNAMES
dnl  
dnl  This sets MKPRIVNAMES to $(top_srcdir)/util/mkprivnames/mkprivnames or
dnl  $RHBINDIR/mkprivnames, depending on what it finds.
dnl  
AC_DEFUN(SGI_PROG_MKPRIVNAMES, [
    SGI_PATH_RHINOPROG(MKPRIVNAMES, mkprivnames)
    AC_SUBST(MKPRIVNAMES)
])


dnl  SGI_PROG_FTRJAVA
dnl  
dnl  This sets FTRJAVA to $(top_srcdir)/util/ftrjava/ftrjava or
dnl  $RHBINDIR/ftrjava, depending on what it finds.
dnl  
AC_DEFUN(SGI_PROG_FTRJAVA, [
    SGI_PATH_RHINOPROG(FTRJAVA, ftrjava)
    AC_SUBST(FTRJAVA)
])


dnl  SGI_PROG_JARLINKS
dnl  
dnl  This sets JARLINKS to $(top_srcdir)/util/jarlinks/jarlinks or
dnl  $RHBINDIR/jarlinks, depending on what it finds.
dnl  
AC_DEFUN(SGI_PROG_JARLINKS, [
    SGI_PATH_RHINOPROG(JARLINKS, jarlinks)
    AC_SUBST(JARLINKS)
])


dnl  SGI_ARG_JAVAPATH
dnl  
dnl  This is sort of a perversion of the AC_ARGS_WITH macro, but I want
dnl  ./configure --help to tell people they can set JAVAPATH.
dnl  
AC_DEFUN(SGI_ARG_JAVAPATH, [
    AC_ARG_WITH(JAVAPATH, [  --with-JAVAPATH=\"/path/to/java\"
                          look in JAVAPATH for java, javac, and jar], [JAVAPATH=$withval], JAVAPATH=${JAVAPATH:-$PATH})
])


dnl  SGI_PATH_JAVAPROG(PROG, prog)
dnl  
AC_DEFUN(SGI_PATH_JAVAPROG, [
    AC_REQUIRE([SGI_ARG_JAVAPATH])dnl
    AC_PATH_PROG($1, $2, die, $JAVAPATH)
    if eval "test \"`echo '$''{'$1'}'`\" = die"; then
        AC_MSG_ERROR([Didn't find $2 in $JAVAPATH
Try running configure --with-JAVAPATH=/path/to/java/bin])
    fi
])


dnl  SGI_PROG_JAVAC
dnl  
AC_DEFUN(SGI_PROG_JAVAC, [
    SGI_PATH_JAVAPROG(JAVAC, javac)
    dnl  This is only necessary because automake doesn't properly expand macros.
    AC_SUBST(JAVAC)
])



dnl  SGI_PROG_JAR
dnl  
AC_DEFUN(SGI_PROG_JAR, [
    SGI_PATH_JAVAPROG(JAR, jar)
    dnl  This is only necessary because automake doesn't properly expand macros.
    AC_SUBST(JAR)
])


dnl  SGI_PROG_JAVADOC
dnl  
AC_DEFUN(SGI_PROG_JAVADOC, [
    SGI_PATH_JAVAPROG(JAVADOC, javadoc)
    dnl  This is only necessary because automake doesn't properly expand macros.
    AC_SUBST(JAVADOC)
])



dnl  SGI_PROG_JAVA
dnl  
dnl  This attempts to work around the weird IBM JRE 1.1.8, which has "jre"
dnl  but not "java", and "jre" ignores CLASSPATH.  (Why??)  If this thinks
dnl  you're using the IBM JRE, this ignores JAVAPATH, but you have to do that
dnl  anyway because IBM's JDK doesn't seem to use IBM's JRE.
dnl  
dnl  This also sets JAVA_IN_MAKEFILE, in case you actually run java during
dnl  the build.  (But in that case, instead of using CLASSPATH, shouldn't
dnl  it use CLASSPATH_ENV, or use /usr/jdk118/bin/java?  If you change this,
dnl  test with SystemImager, as that's what it was added for.)
AC_DEFUN(SGI_PROG_JAVA, [
    AC_REQUIRE([SGI_ARG_JAVAPATH])dnl
    if test "${JAVA+set}" = set; then
        dnl  It's set as an environment variable, so instead of stomping it
        dnl  in the IBM JRE 118 below, let's let AC_PATH_PROG use that value.
        AC_PATH_PROG(JAVA, java)
        AC_PATH_PROG(JAVA_IN_MAKEFILE, java)
    else
        dnl  This is bogus; see comment above.
        if test -f /usr/jre118/bin/jre && test ! -f /usr/jre118/bin/java; then
            JAVA='/usr/jre118/bin/jre -cp $CLASSPATH'
	    JAVA_IN_MAKEFILE='/usr/jre118/bin/jre -cp $$CLASSPATH'
        fi
        SGI_PATH_JAVAPROG(JAVA, java)
        SGI_PATH_JAVAPROG(JAVA_IN_MAKEFILE, java)
    fi
    AC_SUBST(JAVA)
    AC_SUBST(JAVA_IN_MAKEFILE)
])


dnl  SGI_PATH_WEBROOTDIR
dnl
dnl  Find the root of the web server's document tree
dnl
AC_DEFUN(SGI_PATH_WEBROOTDIR, [
    AC_MSG_CHECKING([for web server document root (THIS TEST IS BOGUS)])
    AC_ARG_WITH(WEBROOTDIR, [  --with-WEBROOTDIR=\"/path/to/document/root\"
                          use WEBROOTDIR as www document root], [WEBROOTDIR=$withval], WEBROOTDIR=${WEBROOTDIR})
    if test "x$WEBROOTDIR" = x; then
        webroots="\
            /home/httpd/html \
            /var/www/htdocs \
            /usr/freeware/apache/share/httpd/htdocs"
        for d in $webroots; do
            if test -d $d; then
                WEBROOTDIR=$d
                break
            fi
        done
    fi
    AC_SUBST(WEBROOTDIR)
    AC_MSG_RESULT($WEBROOTDIR)
])


dnl  SGI_PATH_RHINO
dnl  
dnl  This AC_SUBST's a bunch of variables for rhino installation directories.
dnl  
dnl  Right now this slightly bogus; it (sh|c)ould be more configurable.
dnl
dnl  RHDIR          the root of the rhino directory structure, EXCEPT for
dnl                     RHVARDIR.
dnl  RHBINDIR       most rhino executables (but not privcmds).
dnl  RHPRIVBINDIR   privileged commands.
dnl  RHPRIVNMDIR    the mappings of privcmds to human-readable names.
dnl  RHSVCDIR       Rhino service modules.
dnl  RHPROTODIR     Rhino protocol modules.
dnl  RHCATDIR       Rhino category modules.
dnl  RHASSOCDIR     Rhino association modules.
dnl  RHAUTHDIR      Rhino server authentication modules.
dnl  RHAUTHDSODIR   like RHAUTHDIR, only different?
dnl  RHTASKREGDIR   task registry directory.
dnl  RHINCDIR       headers which Rhino-based applications compile with.
dnl  RHLIBDIR       libraries which Rhino-based applications link with.
dnl  RHJARDIR       client jar files.
dnl  RHWEBBINDIR    web-related executables.
dnl  RHCGIDIR       CGI scripts.
dnl  RHCONFIGDIR    certain config files, including the "privileges"
dnl                     configuration file (/etc/config)
dnl  RHLOCALEDIR    the base locale directory
dnl  
dnl  RHVARDIR       the directory where... some... stuff goes.
dnl  RHDEFPRIVDIR   config files enabling specific privcmds.
dnl  RHPRODDIR      directory containing product-specific directories.
dnl                     $RHPRODDIR/foo/ is where the foo product would
dnl                     put its installed product version number, etc.
dnl
AC_DEFUN(SGI_PATH_RHINO, [
    AC_REQUIRE([SGI_EXPAND_PATHS])dnl

    dnl  In the installed .m4 file, the default RHDIR and RHVARDIR values will
    dnl  be replaced with the values which the installed Rhino was configured
    dnl  with.  (This is done by a rule in the top-level Makefile.am.  If you
    dnl  change the defaults from /usr/lib/sysadm and /var/lib/sysadm,
    dnl  remember to update the Makefile.am.)
    AC_ARG_WITH(RHDIR, [  --with-RHDIR=/usr/lib/sysadm
                          look in RHDIR for bin/sysadmd, privbin, etc. [default=${RHDIR-/usr/lib/sysadm}]],
                [RHDIR=$withval], [RHDIR=${RHDIR-/usr/lib/sysadm}])
    AC_ARG_WITH(RHVARDIR, [  --with-RHVARDIR=/var/lib/sysadm
                          look in RHVARDIR for defaultPrivileges, etc. [default=${RHVARDIR-/var/lib/sysadm}]],
                [RHVARDIR=$withval], [RHVARDIR=${RHVARDIR-/var/lib/sysadm}])

    RHBINDIR="${RHDIR}/bin"
    RHPRIVBINDIR="${RHDIR}/privbin"
    RHPRIVNMDIR="${RHDIR}/privnames"
    RHSVCDIR="${RHDIR}/services"
    RHPROTODIR="${RHDIR}/protocols"
    RHCATDIR="${RHDIR}/category"
    RHASSOCDIR="${RHDIR}/association"
    RHAUTHDIR="${RHSVCDIR}/authScheme"
    RHAUTHDSODIR="${RHDIR}/authdso"
    RHINCDIR="$includedir/sysadm"
    RHLIBDIR="${RHDIR}/lib"
    RHJARDIR="${RHDIR}/java"
    RHWEBBINDIR="${RHDIR}/web"
#XXX THIS IS SO BOGUS
    RHCGIDIR="/var/www/cgi-bin/sysadm"
#XXX THIS IS SO BOGUS TOO
    RHCONFIGDIR="/etc/config"
    RHLOCALEDIR="${datadir}/locale"
    AC_SUBST(RHDIR)
    AC_SUBST(RHBINDIR)
    AC_SUBST(RHPRIVBINDIR)
    AC_SUBST(RHPRIVNMDIR)
    AC_SUBST(RHSVCDIR)
    AC_SUBST(RHPROTODIR)
    AC_SUBST(RHCATDIR)
    AC_SUBST(RHASSOCDIR)
    AC_SUBST(RHAUTHDIR)
    AC_SUBST(RHAUTHDSODIR)
    AC_SUBST(RHINCDIR)
    AC_SUBST(RHLIBDIR)
    AC_SUBST(RHJARDIR)
    AC_SUBST(RHWEBBINDIR)
    AC_SUBST(RHCGIDIR)
    AC_SUBST(RHCONFIGDIR)
    AC_SUBST(RHLOCALEDIR)

    RHDEFPRIVDIR="${RHVARDIR}/defaultPrivileges"
    RHPRODDIR="${RHVARDIR}/products"
    RHTASKREGDIR="${RHVARDIR}/taskRegistry"
    AC_SUBST(RHVARDIR)
    AC_SUBST(RHDEFPRIVDIR)
    AC_SUBST(RHPRODDIR)
    AC_SUBST(RHTASKREGDIR)
])

