#!/bin/sh
#
# testit.sh
#
#	test addpriv and rmpriv.
#	
# Copyright 1995, Silicon Graphics, Inc.
# ALL RIGHTS RESERVED
# 
# UNPUBLISHED -- Rights reserved under the copyright laws of the United
# States.   Use of a copyright notice is precautionary only and does not
# imply publication or disclosure.
# 
# U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
# Use, duplication or disclosure by the Government is subject to restrictions
# as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
# in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
# in similar or successor clauses in the FAR, or the DOD or NASA FAR
# Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
# 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
#
# THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
# INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
# DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
# PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
# GRAPHICS, INC.
# 
#
# $Revision: 1.6 $
#

# Add a root password so privileges are not automatic
/bin/addRootPassword

# Get rid of any cruft left over from previous runs
for privilege in test1 test2 test3 test4 test5 test6 test7
do
	/usr/sysadm/bin/rmpriv -all $privilege
	if fgrep -s $privilege /var/sysadm/privilege
	then
		echo Error: rmpriv -all $privilege did not work
	fi
done

rm -f /usr/sysadm/defaultPrivileges/*
rm -f /usr/sysadm/privilegedUsers

# Do a simple addpriv/remove test
/usr/sysadm/bin/addpriv rogerc test1
if su rogerc -c "/usr/sysadm/bin/checkpriv test1"
then
	:
else
	echo Error: checkpriv test1 for rogerc failed 1>&2
fi

/usr/sysadm/bin/rmpriv rogerc test1
if su rogerc -c "/usr/sysadm/bin/checkpriv test1"
then
	echo Error: checkpriv test1 for rogerc succeeded 1>&2
fi

# Make sure checkpriv fails before addpriv is run, and succeeds afterward.
for priv in test1 test2 test3 test4
do
	for user in rogerc amy leung guest
	do
		if su $user -c "/usr/sysadm/bin/checkpriv $priv"
		then
			echo Error: checkpriv $priv for $user succeeded 1>&2
		fi

		/usr/sysadm/bin/addpriv $user $priv

		if su $user -c "/usr/sysadm/bin/checkpriv $priv"
		then
			:
		else
			echo Error: checkpriv $priv for $user failed 1>&2
		fi
	done
done

# Make sure checkpriv succeeds every time.
for priv in test1 test2 test3 test4
do
	for user in rogerc amy leung guest
	do
		if su $user -c "/usr/sysadm/bin/checkpriv $priv"
		then
			:
		else
			echo Error: checkpriv $priv for $user failed 1>&2
		fi
	done
done

# Make sure checkpriv succeeds before rmpriv is run, and fails
# afterward.  We remove in a different order than we added to make
# sure addpriv and rmpriv are not sensitive to the order in which the
# privilege database is laid out.
for priv in test2 test1 test4 test3
do
	for user in amy rogerc guest leung
	do
		if su $user -c "/usr/sysadm/bin/checkpriv $priv"
		then
			:
		else
			echo Error: checkpriv $priv for $user failed 1>&2
		fi

		/usr/sysadm/bin/rmpriv $user $priv

		if su $user -c "/usr/sysadm/bin/checkpriv $priv"
		then
			echo Error: checkpriv $priv for $user succeeded 1>&2
		fi
	done
done

# Make sure -auth option of addpriv works right.
if su rogerc -c "echo blah | /usr/sysadm/bin/addpriv -auth unix rogerc checkAuth"
then
	:
else
	echo Error: addpriv -auth unix failed 1>&2
fi

if su rogerc -c "/usr/sysadm/bin/checkpriv checkAuth"
then
	:
else
	echo Error: checkpriv checkAuth failed for rogerc 1>&2
fi

# Make sure addpriv works with multiple privileges.
/usr/sysadm/bin/addpriv leung test5
/usr/sysadm/bin/addpriv amy test5
/usr/sysadm/bin/addpriv ruffles test5
/usr/sysadm/bin/addpriv ctb test6
/usr/sysadm/bin/addpriv rogerc test6
privlist="test5 test6 test7"
if /usr/sysadm/bin/addpriv rogerc $privlist
then
	:
else
	echo Error: addpriv with multiple privileges failed 1>&2
fi

for priv in $privlist
do
	if su rogerc -c "/usr/sysadm/bin/checkpriv $priv"
	then
		:
	else
		echo Error: checkpriv $priv for rogerc failed 1>&2
	fi
done

/usr/sysadm/bin/rmpriv -all checkAuth

##
# Default privileges section
##
/usr/sysadm/bin/rmpriv -all defPriv

# Make sure adddefpriv works
if /usr/sysadm/bin/adddefpriv defPriv
then
	:
else
	echo Error: adddefpriv defPriv failed 1>&2
fi
for user in rogerc amy leung guest
do
	if su $user -c "/usr/sysadm/bin/checkpriv defPriv"
	then
		:
	else
		echo Error: checkpriv defPriv for $user failed 1>&2
	fi
done

# Make sure rmdefpriv works
if /usr/sysadm/bin/rmdefpriv defPriv
then
	:
else
	echo Error: rmdefpriv defPriv failed 1>&2
fi
for user in rogerc amy leung guest
do
	if su $user -c "/usr/sysadm/bin/checkpriv defPriv"
	then
		echo Error: checkpriv defPriv for $user succeeded 1>&2
	fi
done

# Test -auth option of adddefpriv
/usr/sysadm/bin/rmpriv -all authDefPriv
if su rogerc -c "echo blah | /usr/sysadm/bin/adddefpriv -auth unix authDefPriv"
then
	:
else
	echo Error: adddefpriv -auth failed 1>&2
fi
for user in rogerc amy leung guest
do
	if su $user -c "/usr/sysadm/bin/checkpriv authDefPriv"
	then
		:
	else
		echo Error: checkpriv authDefPriv for $user failed 1>&2
	fi
done

# Test -auth option of rmdefpriv
if su rogerc -c "echo blah | /usr/sysadm/bin/rmdefpriv -auth unix authDefPriv"
then
	:
else
	echo Error: adddefpriv -auth failed 1>&2
fi
for user in rogerc amy leung guest
do
	if su $user -c "/usr/sysadm/bin/checkpriv authDefPriv"
	then
		echo Error: checkpriv authDefPriv for $user succeeded 1>&2
	fi
done

##
# Privileged user section
##
/usr/sysadm/bin/rmpriv -all privUser

# Test addprivuser.
if /usr/sysadm/bin/addprivuser rogerc
then
	:
else
	echo Error: addprivuser rogerc failed 1>&2
fi
if su rogerc -c "/usr/sysadm/bin/checkpriv privUser"
then
	:
else
	echo Error: checkpriv privUser failed for rogerc 1>&2
fi
if su leung -c "/usr/sysadm/bin/checkpriv privUser"
then
	echo Error: checkpriv privUser succeeded for leung 1>&2
fi

# Test rmprivuser.
if /usr/sysadm/bin/rmprivuser rogerc
then
	:
else
	echo Error: rmprivuser rogerc failed 1>&2
fi
if su rogerc -c "/usr/sysadm/bin/checkpriv privUser"
then
	echo Error: checkpriv privUser succeeded for rogerc 1>&2
fi

# Test -auth option of addprivuser
/usr/sysadm/bin/rmpriv -all authPrivUser
if su rogerc -c "echo blah | /usr/sysadm/bin/addprivuser -auth unix leung"
then
	:
else
	echo Error: addprivuser -auth failed 1>&2
fi
if su leung -c "/usr/sysadm/bin/checkpriv authPrivUser"
then
	:
else
	echo Error: checkpriv authPrivUser failed for leung 1>&2
fi
if su rogerc -c "/usr/sysadm/bin/checkpriv authPrivUser"
then
	echo Error: checkpriv authPrivUser succeeded for rogerc 1>&2
fi

# Test -auth option of rmprivuser
if su rogerc -c "echo blah | /usr/sysadm/bin/rmprivuser -auth unix leung"
then
	:
else
	echo Error: rmprivuser -auth failed 1>&2
fi
if su leung -c "/usr/sysadm/bin/checkpriv authPrivUser"
then
	echo Error: checkpriv authPrivUser succeeded for leung 1>&2
fi

# Test for really stupid security holes.

su rogerc -c "/usr/sysadm/bin/addpriv hacker" >/dev/null 2>&1
su rogerc -c "echo bogus | /usr/sysadm/bin/addpriv -auth unix hacker" >/dev/null 2>&1
su rogerc -c "/usr/sysadm/bin/adddefpriv hacker" >/dev/null 2>&1
su rogerc -c "echo bogus | /usr/sysadm/bin/adddefpriv -auth unix hacker" >/dev/null 2>&1
su rogerc -c "/usr/sysadm/bin/addprivuser rogerc" >/dev/null 2>&1
su rogerc -c "echo bogus | /usr/sysadm/bin/addprivuser -auth unix rogerc" >/dev/null 2>&1
if su rogerc -c "/usr/sysadm/bin/checkpriv hacker"
then
	echo Error: Found a stupid security hole 1>&2
fi

/bin/removeRootPassword
