#!/bin/sh
#
# testit.sh
#
#	Run a bunch of tests on "checkpriv" to make sure it works
#	right.
#	
# Copyright 1995, Silicon Graphics, Inc.
# ALL RIGHTS RESERVED
# 
# UNPUBLISHED -- Rights reserved under the copyright laws of the United
# States.   Use of a copyright notice is precautionary only and does not
# imply publication or disclosure.
# 
# U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
# Use, duplication or disclosure by the Government is subject to restrictions
# as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
# in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
# in similar or successor clauses in the FAR, or the DOD or NASA FAR
# Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
# 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
#
# THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
# INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
# DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
# PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
# GRAPHICS, INC.
# 
#
# $Revision: 1.8 $
#

/etc/chkconfig privileges on
/bin/addRootPassword

for user in root rogerc leung amy lp guest
do
	for privilege in testPriv1 testPriv2 testPriv3 bogus
	do
		/bin/su $user -c "./checkpriv $privilege"
	done
done

/bin/su rogerc -c "./checkpriv testPriv2 testPriv3"
/bin/su rogerc -c "./checkpriv testPriv6 testPriv2 testPriv3"
/bin/su rogerc -c "./checkpriv testPriv2 testPriv4"
/bin/su amy -c "./checkpriv testPriv1 testPriv4 testPriv5"
/bin/su amy -c "./checkpriv testPriv1 testPriv3"
/bin/su amy -c "./checkpriv testPriv2 testPriv1"
/bin/su amy -c "./checkpriv testPriv2 testPriv1 testPriv3"
/bin/su amy -c "./checkpriv testPriv2 testPriv1 testPriv4 testPriv3"
/bin/su amy -c "./checkpriv testPriv1 testPriv2 testPriv3 testPriv4"

#
# Default privileges
#
echo "on" > /var/sysadm/defaultPrivileges/defPriv1
/bin/su rogerc -c "./checkpriv defPriv1"

echo "on" > /var/sysadm/defaultPrivileges/defPriv2
echo "on" > /var/sysadm/defaultPrivileges/defPriv3
/bin/su rogerc -c "./checkpriv defPriv1 defPriv2 defPriv3"

rm -f /var/sysadm/defaultPrivileges/defPriv2
rm -f /var/sysadm/defaultPrivileges/defPriv3
/bin/su rogerc -c "./checkpriv defPriv1 defPriv2 defPriv3"

echo "off" > /var/sysadm/defaultPrivileges/defPriv1
/bin/su rogerc -c "./checkpriv defPriv1"

rm -f /var/sysadm/defaultPrivileges/defPriv1
/bin/su rogerc -c "./checkpriv defPriv1"

#
# Privileged users
#
rm -f /var/sysadm/privilegedUsers
echo "rogerc" >  /var/sysadm/privilegedUsers
/bin/su rogerc -c "./checkpriv privUser"

/bin/su amy -c "./checkpriv privUser"

echo "amy" >> /var/sysadm/privilegedUsers
/bin/su amy -c "./checkpriv privUser"

rm -f /var/sysadm/privilegedUsers
/bin/su rogerc -c "./checkpriv privUser"

/bin/removeRootPassword

for user in root rogerc leung amy lp guest
do
	for privilege in testPriv1 testPriv2 testPriv3 bogus
	do
		/bin/su $user -c "./checkpriv $privilege"
	done
done

#
# Make sure checkpriv -reason works right.
#
/usr/sysadm/bin/addpriv rogerc reasonCheck

reason=`/usr/sysadm/bin/checkpriv -reason reasonCheck`
if [ "$reason" != 1 ]
then
	echo Error: checkpriv -reason did not print SAIsRoot 1>&2
fi

reason=`su rogerc -c "/usr/sysadm/bin/checkpriv -reason reasonCheck"`
if [ "$reason" != 2 ]
then
	echo Error: checkpriv -reason did not print SANoRootPassword 1>&2
fi

/bin/addRootPassword

reason=`su rogerc -c "/usr/sysadm/bin/checkpriv -reason reasonCheck"`
if [ "$reason" != 3 ]
then
	echo Error: checkpriv -reason did not print SaNoHasPriv 1>&2
fi

/usr/sysadm/bin/rmpriv rogerc reasonCheck

reason=`su rogerc -c "echo blah | /usr/sysadm/bin/checkpriv -auth unix -reason reasonCheck"`
if [ "$reason" != 4 ]
then
	echo Error: checkpriv -reason did not print SaAuthPassed 1>&2
	echo        instead, it printed $reason 1>&2
fi

/usr/sysadm/bin/rmpriv -all reasonCheck

#
# Make sure checkpriv -auth works right.
#

if su rogerc -c "echo blah | /usr/sysadm/bin/checkpriv -auth unix bogus"
then
	:
else
	echo Error: checkpriv -auth unix failed with valid password. 1>&2
fi

if su rogerc -c "echo invalid | /usr/sysadm/bin/checkpriv -auth unix bogus"
then
	echo Error: checkpriv -auth unix succeeded with invalid password. 1>&2
fi

/bin/removeRootPassword
