#!/usr/bin/perl
#
# usage: jarfiles [ -applet ] <jar-file> ...
#
# jarfiles prints a list of .jar files in $JARDIR based
# on the language (determined by examining the LANG (applications) or
# APPLET_LANG (applets) environment variable) and .jar files specified
# on the command line.  The reason that applets use a separate
# environment variable for language specification is to avoid having
# the perl program print obnoxious warnings about the locale setting
# failed.
#
# The purpose of jarfiles is to support the localization of java
# programs.  The idea is that a separate .jar file is supplied for
# each locale, and .properties files within a locale-specific .jar file
# override .properties files within the default .jar file.
#
# jarfiles assumes a convention in which .class and .properties files
# are stored in separate .jar files.  For example, sysadm.jar contains
# all of the .class files for the sysadm client, and sysadmP.jar contains
# the .properties files (and .gif files).
#
# When sysadm is localized to Canadian French, the .properties files
# in sysadmP.jar are translated and stored in sysadmP_fr_CA.jar.
# sysadmP_fr_CA.jar can then be installed in /usr/sysadm/java as part
# of a worldview product, and "env LANG= fr_CA jarfiles sysadm.jar"
# will print:
#
#   sysadmP_fr_CA.jar sysadmP.jar sysadm.jar
#
# Consumers of jarfiles output will place these .jar files in
# CLASSPATH (application) or ARCHIVE (applet).  Thus any localized
# settings from .properties files in sysadmP_fr_CA.jar will override
# settings from .properties files in sysadmP.jar.  .properties files
# or .gif files in sysadmP.jar that did not need to be translated can
# be omitted from sysadmP_fr_CA.jar, since sysadmP.jar is in the list.
#
# This scheme allows a java program to be localized without changing the
# contents of any .jar files.
#
# The applet tag causes jarfiles to print .jar files in reverse order,
# since in applets the later .jar files override the previous ones.

$applet = 0;
$ii = 0;
if ($#ARGV > -1 && $ARGV[0] =~ "-applet") {
    $applet = 1;
    $ii++;
}

$numJars = 0;
while ($ii <= $#ARGV) {
    $jar = $ARGV[$ii++];
    #
    # This check prevents things like
    # "../../../usr/people/guest/sysadm.jar" from being used to
    # download things outside of the document root.
    #
    if ($jar =~ /^([\w\.]+\.jar)/) {
	$jars[$numJars++] = $1;
    } else {
	die "$jar is not a valid JAR name\n";
    }
}

@files = ();
$jarDir = $ENV{'JARDIR'};
if ($applet) {
    $lang = $ENV{'APPLET_LANG'};
} else {
    $lang = $ENV{'LANG'};
}
$numFiles = $0;

for ($ii = 0; $ii < $numJars; $ii++) {
    $jar = $jars[$ii];
    $base = $jar;
    $base =~ s/\.jar$/P/;
    $file = "$base" . "_" . "$lang.jar";
    while (! -f "$jarDir/$file") {
	$newFile = $file;
	$newFile =~ s/_[^_]*.jar/.jar/;
	if ("$file" =~ "$newFile") {
	    die "Error: no .jar file found for $jar\n";
	}
	$file = $newFile;
    }
    $files[$numFiles++] = $file;
    if ("$file" !~ "$base.jar") {
	$files[$numFiles++] = "$base.jar";
    }
}

for ($ii = 0; $ii < $numJars; $ii++) {
    $files[$numFiles++] = $jars[$ii];
}

#
# For applets, .jar files later in the list override .jar files
# earlier in the list.  For applications, .jar files earlier
# in the list override .jar files later in the list.
#
if ($applet) {
    for ($ii = 0; $ii < $numFiles / 2; $ii++) {
	$temp = $files[$ii];
	$files[$ii] = $files[$numFiles - $ii - 1];
	$files[$numFiles - $ii - 1] = $temp;
    }
}
print "@files\n";
