#!/usr/bin/perl
#
# This script prints out the list of process ids corresponding to sysadmd
# instances.  It gets the list of process ids from "ps" and the corresponding
# hosts from SYSLOG.
#

require "getopts.pl";
&Getopts('h');    

$headers = 1;
if ($opt_h) {
    $headers = 0;
}

#
# Collect process ids of sysadmd instances.
#
open(PS, "ps -e -o pid=,comm= |") || die "ps: $!\n";
$numDaemons = 0;
while ($line = <PS>) {
    if ($line =~ /([0-9]+) .*sysadmd/) {
	$pids[$numDaemons++] = $1;
    }
}
close(PS);

#
# Construct a hash table mapping process ids to hostnames.
#
open(SYSLOG, "/var/adm/SYSLOG") || die "/var/adm/SYSLOG: $!\n";
while ($line = <SYSLOG>) {
    if ($line =~ /sysadmd\[([0-9]+)\].*host: (.*)$/) {
	$hosts{$1} = $2;
    }
}
close(SYSLOG);

#
# For each process in our ps listing, print the client hostname.
#
if ($headers) {
    print "        PID HOST\n";
}
for ($ii = 0; $ii < $numDaemons; $ii++) {
    $pid = $pids[$ii];
    printf("%11d %s\n", $pid, $hosts{$pid});
}
