#!/usr/bin/perl

if ($#ARGV == -1) {
    $ENV{'CLASSPATH'} = "/usr/sysadm/java/rhino.jar:/usr/sysadm/java/sysadm.jar:/usr/sysadm/java/sysadmP.jar:/usr/sysadm/java/swingall.jar";
    exec("/usr/sysadm/bin/javawait -command /usr/java/bin/java com.sgi.sysadm.manager.RunTask -s localhost -n -l $ENV{'USER'} rhino.task.MakeRhinoIsmTask");
}

require "getopts.pl";
&Getopts('d:i:o:p:');
if (!$opt_d || !$opt_i || !$opt_o || !$opt_p || $#ARGV != -1) {
    die("usage: mkrhinoism -i ism-name -o obj-name -p prod-name -d dest-dir\n");
}

if (! -d $opt_d) {
    mkdir($opt_d, 0755) || die("$opt_d: $!\n");
}

opendir(DIR, $opt_d) || die("$opt_d: $!\n");
@entries = readdir(DIR);
closedir(DIR);
if ($#entries != 1) {
    die("$opt_d must be an empty directory\n");
}

print("    Copying files from bonnie...\n");
$| = 1;
$status = system("/usr/bsd/rsh bonnie -l guest \"(cd /isms/rhino/1.1/example; find . -follow -type f \! -name \\*,v -print | xargs tar cBf -)\" | (cd $opt_d; tar xBf -)");
if ($status / 256 != 0) {
    die("\nUnable to copy files from bonnie to $opt_d\n");
}

$allUppser = uc($opt_o);
$allLower = lc($opt_o);
$initUpper = ucfirst($allLower);

sub newName {
    local($name) = @_;
    
    $name =~ s/RHINO_EXAMPLE/OBJ/g;
    $name =~ s/rhinoexample/$opt_p/g;
    $name =~ s/rhinoExample/$allLower/g;
    $name =~ s/rhino[ ]+example/$opt_p/g;
    $name =~ s/Rhino[ ]*Example/$initUpper/g;
    $name =~ s/rhexamp/$opt_i/g;
    return $name;
}

print("    Renaming directories...\n");
do {
    $numSubs = 0;
    open(DIRS, "find $opt_d -type d |") || die("find: $!\n");
    while ($numSubs == 0 && ($dir = <DIRS>)) {
	chop($dir);
	$newName = &newName($dir);
	if ($dir ne $newName) {
#	    print("$dir -> $newName\n");
	    rename($dir, $newName) || die("$dir: $!\n");
	    $numSubs++;
	}
    }
    close(DIRS);
} while ($numSubs > 0);

print("    Renaming files...\n");
open(FILES, "find $opt_d -type f |") || die("find: $!\n");
while ($file = <FILES>) {
    chop($file);
    $newName = &newName($file);
    if ($file ne $newName) {
#	print("$file -> $newName\n");
	rename($file, $newName) || die("$file: $!\n");
    }
    open(FILE, $newName) || die("$newName: $!\n");
    open(NEWFILE, ">$newName.new") || die("$newName.new: $!\n");
    while ($line = <FILE>) {
	print(NEWFILE &newName($line));
    }
    close(FILE);
    close(NEWFILE);
    rename("$newName.new", $newName) || die("$newName: $!\n");
}
close(FILES);
