#!/usr/bin/perl -w
#
# testEnv.sh
#
#	Test runpriv's handling of the environment
#	
# Copyright 1995, Silicon Graphics, Inc.
# ALL RIGHTS RESERVED
# 
# UNPUBLISHED -- Rights reserved under the copyright laws of the United
# States.   Use of a copyright notice is precautionary only and does not
# imply publication or disclosure.
# 
# U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
# Use, duplication or disclosure by the Government is subject to restrictions
# as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
# in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
# in similar or successor clauses in the FAR, or the DOD or NASA FAR
# Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
# 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
#
# THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
# INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
# DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
# PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
# GRAPHICS, INC.
# 
#
# $Revision: 1.5 $
#

sub runPrivEnv
{
    local(@privEnv) = ();
    local($nVars) = 0;
    open(ENV, "/var/sysadm/privenviron") ||
	die("Error: /var/sysadm/privenviron: $!\n");

    while ($var = <ENV>) {
	chop $var;
	if ($var =~ /[^=]+=.*/) {
	    $privEnv[$nVars++] = $var;
	} elsif ($val = $ENV{$var}) {
	    $privEnv[$nVars++] = "$var=$val";
	}
    }
	    
    return @privEnv;
}

sub testEnv
{
    $hasPriv = system("/usr/sysadm/bin/checkpriv environ") == 0;

    if (!$hasPriv
	&& system("/usr/sysadm/bin/runpriv environ > /dev/null 2>&1") == 0) {
	die "Error: runpriv executed environ when it shouldn't have\n";
    }

    if ($hasPriv) {
	@runPrivEnv = &runPrivEnv();

	open(RUNPRIV, "/usr/sysadm/bin/runpriv environ |") ||
	    die "Error: Can't run runpriv $!\n";

	while (<RUNPRIV>) {
	    chop;
	    $env = shift @runPrivEnv ||
		die "Error: runpriv has too many environment variables\n";
	    if ($env ne $_) {
		die "Error: runpriv got $_ wrong\n";
	    }
	}
	close(RUNPRIV);

	if ($#runPrivEnv > -1) {
	    die "Error: runpriv doesn't have enough environment variables\n";
	}
    }
}

&testEnv
