#!/usr/bin/perl -w
#
# testPerm.sh
#
#	Test runpriv's handling of bogus permissions
#	
# Copyright 1995, Silicon Graphics, Inc.
# ALL RIGHTS RESERVED
# 
# UNPUBLISHED -- Rights reserved under the copyright laws of the United
# States.   Use of a copyright notice is precautionary only and does not
# imply publication or disclosure.
# 
# U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
# Use, duplication or disclosure by the Government is subject to restrictions
# as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
# in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
# in similar or successor clauses in the FAR, or the DOD or NASA FAR
# Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
# 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
#
# THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
# INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
# DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
# PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
# GRAPHICS, INC.
# 
#
# $Revision: 1.5 $
#

$redirect = ">/dev/null 2>&1";

system("/usr/sysadm/bin/runpriv perm $redirect") != 0 ||
    die "Error: runpriv ran perm\n";

chmod 0666, "/var/sysadm/privilege" ||
    die "Error: privilege: $!\n";

system("/usr/sysadm/bin/runpriv hello $redirect") != 0 ||
    die "Error: runpriv ran hello w/ world write privilege db\n";

chmod 0444, "/var/sysadm/privilege" ||
    die "Error: privilege: $!\n";

chmod 0666, "/usr/sysadm/authdso/unix.so" ||
    die "Error: unix.so: $!\n";

system("su rogerc -c \"/usr/sysadm/bin/runpriv -auth unix hello\" $redirect")
    != 0 || die "Error: runpriv ran hello w/ world write unix.so\n";

chmod 0444, "/usr/sysadm/authdso/unix.so" ||
    die "Error: unix.so: $!\n";

chmod 0777, "/var/sysadm" ||
    die "Error: privilege: $!\n";

system("/usr/sysadm/bin/runpriv hello $redirect") != 0 ||
    die "Error: runpriv ran hello w/ world write /var/sysadm dir\n";

chmod 0755, "/var/sysadm" ||
    die "Error: privilege: $!\n";
