//
// FileLogListener.c++
//
//	Log output to a file.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2 of the GNU General Public License as
//  published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.6 $"

#include <unistd.h>

#include <sysadm/i18n.h>

#include "FileLogListener.h"

//
// Name of the remote host we're connected to.
//
String FileLogListener::_remoteHost(String::EMPTY);

//
// FileLogListener constructor.
//
FileLogListener::FileLogListener(FILE* fp)
: _fp(fp), _pid(getpid())
{
}

//
// FileLogListener destructor.
//
FileLogListener::~FileLogListener()
{
    fclose(_fp);
}

//
//  void FileLogListener::handleMessage(const char* module,
//  				        Log::Level level,
//  				        const char* format, va_list args)
//
//  Description:
//      Log a message to a file.
//
//  Parameters:
//      module    module that logged this message.
//      level     Log::TRACE .. Log::FATAL.
//      format    printf-style format string.
//      args      arguments for printf string.
//
void FileLogListener::handleMessage(const char* module,
				    Log::Level level,
				    const char* format, va_list args)
{
    fprintf(_fp, "%s %s %s[%d]: ", Log::levelToString(level),
	    (const char*)_remoteHost, module, _pid);
    vfprintf(_fp, format, args);
    putc('\n', _fp);
    fflush(_fp);
}

//
//  void FileLogListener::setRemoteHost(String remoteHost)
//
//  Description:
//      Set the remote host that we're connected to.  This information
//      will be part of the messages we print.
//
//  Parameters:
//      remoteHost  Remote host we're connected to.
//
void FileLogListener::setRemoteHost(String remoteHost)
{
    _remoteHost = remoteHost;
}
