//
// SysadmListener.h
//
//	PacketListener that starts sysadm services.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2 of the GNU General Public License as
//  published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.11 $"

#include <sysadm/PacketListener.h>
#include <sysadm/Connection.h>
#include <sysadm/DictionaryOf.h>

USING_NAMESPACE(sysadm);

class Service;

//
// SysadmListener's receivePacket() method gets called for packets
// received for the SYSADM_SERVICE.  The SYSADM_SERVICE supports
// AUTH_SCHEME requests for authenticating the client, and LOAD and
// UNLOAD requests for controlling the lifetimes of other services.
//
class SysadmListener : public PacketListener {

  public:

    static const char* SYSADM_SERVICE;

    static const char* REMOTE_HOST;

    static const char* AUTH_SCHEME;
    static const char* LOAD;
    static const char* UNLOAD;
    static const char* LOAD_AUTH;
    static const char* SET_REMOTE_HOST;
    static const char* GET_REMOTE_HOST;
    static const char* PING;
    static const char* SYSADM_VERSION;

    static const char* COOKIE;
    static const char* RESULT;
    static const char* REASON;
    static const char* PRODUCT;
    static const char* PRODUCT_VERSION;
    static const char* SERVER_PRODUCT_VERSION;
    static const char* CLIENT_PRODUCT_VERSION;
    

    // Constructor.
    SysadmListener(Connection& conn);

    // Destructor.
    virtual ~SysadmListener();

    // Set the list of allowable authentication schemes.  If this is
    // never called, "unix" is the only allowable authentication
    // scheme.
    void adoptAuthSchemeList(CollectionOf<String>* authSchemeList);

    // Called by Connection when a packet for the "sysadmd" service is
    // received.
    virtual void receivePacket(const Packet& packet);

  private:

    // Handle a "loadAuth" request.
    void loadAuthScheme(const Packet& packet);

    // Handle a "load" request.
    void load(const Packet& packet);

    // Handle an "unload" request.
    void unload(const Packet& packet);

    // Handle a "setRemoteHost" request
    void setRemoteHost(const Packet& packet);

    // Handle a "getRemoteHost" request
    void getRemoteHost(const Packet& packet);

    // Respond to the request represented by "packet".  Tell the
    // client that the request succeeded.
    void success(const Packet& packet);

    // Respond to the request represented by "packet".  Tell the
    // client that the request failed.  "reason" is a string
    // representing the reason for the failure.
    void error(const Packet& packet, const String& reason);

    void checkServiceName(const String& serviceName);

    void checkAuthSchemeName(const String& authScheme);
    
    bool checkVersion(const Packet& packet);
    void checkProductVersion(const Packet& packet);

    friend class SysadmAuthResultListener;

    Connection& _conn;
    bool _authenticated;
    bool _versionOk;
    DictionaryOf<Service> _services;
    String _authScheme;
    CollectionOf<String>* _authSchemeList;
    Service* _auth;
};
