//
// SyslogListener.c++
//
//	Log listener that prints appropriate messages to syslog.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2 of the GNU General Public License as
//  published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.9 $"

#include <syslog.h>
#include <string.h>
#include <stdio.h>

#include <sysadm/i18n.h>
#include <sysadm/format.h>

#include "SyslogListener.h"

USING_NAMESPACE(sysadm);

//
// Name of the remote host we're connected to.
//
String SyslogListener::_remoteHost(String::EMPTY);

//
//  void SyslogListener::handleMessage(const char* module, Log::Level level,
//  				       const char* format, va_list args)
//
//  Description:
//      Log a message to syslog.
//
//  Parameters:
//      module    The module logging this message.
//      level     Log::TRACE .. Log::FATAL.
//      format    printf-style format string.
//      args      args for format.
//
void SyslogListener::handleMessage(const char* module, Log::Level level,
				   const char* format, va_list args)
{
    char buf[Log::MAXLEN];
    SaStringFormat(buf, sizeof buf, "%s %s:", (const char*)_remoteHost,
	     module);
    SaStringFormatV(buf + strlen(buf), sizeof buf - strlen(buf),
		    format, args);
    syslog(flags(level), "%s", buf);
}

//
//  void SyslogListener::setRemoteHost(String remoteHost)
//
//  Description:
//      Set the remote host that we're connected to.  This information
//      will be part of the messages we print.
//
//  Parameters:
//      remoteHost  Remote host we're connected to.
//
void SyslogListener::setRemoteHost(String remoteHost)
{
    _remoteHost = remoteHost;
}

//
//  int SyslogListener::flags(Log::Level level)
//
//  Description:
//      Translate Log::Level into a flags argument for syslog().
//
//  Parameters:
//      level  Log::FATAL .. Log::TRACE.
//
//  Returns:
//	flags arg for syslog().
//
int SyslogListener::flags(Log::Level level)
{
    int flags = LOG_DAEMON;
    switch (level) {
    case Log::FATAL:
    case Log::ERROR:
	flags |= LOG_ERR;
	break;
    case Log::WARNING:
	flags |= LOG_WARNING;
	break;
    case Log::INFO:
	flags |= LOG_INFO;
	break;
    case Log::DEBUG:
    case Log::TRACE:
    default:
	flags |= LOG_DEBUG;
	break;
    }
    return flags;
}
