//
// SyslogListener.h
//
//	Log listener that prints appropriate messages to syslog.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2 of the GNU General Public License as
//  published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.4 $"

#include <sys/types.h>

#include <sysadm/LogListener.h>
#include <sysadm/Log.h>
#include <sysadm/String.h>

USING_NAMESPACE(sysadm);

//
// SyslogListener logs messages from sysadm to syslog.
//
class SyslogListener : public LogListener {
  public:
    // log messages to syslog.
    virtual void handleMessage(const char* module, Log::Level level,
			       const char* format, va_list args);
    // Set the remote host name to be used when logging.
    static void setRemoteHost(String remoteHost);
  private:
    int flags(Log::Level level);
    static String _remoteHost;
};
