/*
 * privdefs.h
 *
 *	#include file privilege #defines
 *
 *
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.10 $"

#ifndef _PRIVDEFS_H_
#define _PRIVDEFS_H_
#ifdef __cplusplus
extern "C" {
#endif

/*
 * The "priv" commands: executables that implement the privilege mechanism.
 */
#define SaADDDEFPRIV  CONFIG_BIN_DIR "/adddefpriv"
#define SaADDPRIV     CONFIG_BIN_DIR "/addpriv"
#define SaADDPRIVUSER CONFIG_BIN_DIR "/addprivuser"
#define SaCHECKPRIV   CONFIG_BIN_DIR "/checkpriv"
#define SaRMDEFPRIV   CONFIG_BIN_DIR "/rmdefpriv"
#define SaRMPRIV      CONFIG_BIN_DIR "/rmpriv"
#define SaRMPRIVUSER  CONFIG_BIN_DIR "/rmprivuser"
#define SaRUNPRIV     CONFIG_BIN_DIR "/runpriv"

/*
 * Exit codes for runpriv(1M) and checkpriv(1M).
 */
#define SaPRIVOK (0)		/* checkpriv says user has privilege */
#define SaPRIVNOMEM (1)	/* Out of memory */
#define SaPRIVERROR (2)	/* Someone is trying to spoof runpriv */
#define SaPRIVUSAGE (3)	/* Bad command line arguments */
#define SaPRIVNOTPRIV (4)	/* User does not have privilege */
#define SaPRIVNOENV (5)	/* /var/sysadm/privenviron is missing */
#define SaPRIVNOHOME (6)	/* /var/sysadm/privhome is missing */
#define SaPRIVEXECFAIL (7)	/* runpriv Couldn't exec the privilege */
#define SaPRIVNOTSETUID (8)	/* runpriv/checkpriv is not setuid root */
#define SaPRIVNOLOG (9)		/* Can't open log (SaLogOpen(3Sa) failed */

/*
 * Privileged commands can use this exit status to indicate that they
 * must be run as root when run by some other user.
 */
#define SaPRIVNOTROOT (10)

/*
 * First exit code available for privilege commands.  Exit codes less
 * than SaFIRSTAPPCODE are reserved for runpriv(1M).
 */
#define SaFIRSTAPPCODE (20)

/*
 * checkpriv(1M) prints one of these values (converted to ASCII
 * decimal) if its exit status is SaPRIVOK and it was passed the
 * "-reason" argument.
 */
typedef enum { SaNotPriv, SaIsRoot, SaNoRootPassword, SaHasPriv,
	   SaAuthPassed } SaPrivResult;

#ifdef __cplusplus
}
#endif
#endif /* _PRIVDEFS_H_ */
