/*
 * privilege.h
 *
 *	#include file for runpriv, checkpriv, addpriv, and rmpriv (the
 *	"priv" commands).  Any other code should be including
 *	<sysadm/privdefs.h>, not this file.  The API exported here is
 *	only intended for the "priv" commands; higher level software
 *	should run the "priv" commands and use privdefs.h to examine
 *	their exit codes and output instead of this API.
 *
 *
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.18 $"

#ifndef _PRIVILEGE_H_
#define _PRIVILEGE_H_
#ifdef __cplusplus
extern "C" {
#endif

#include <sysadm/sysadm.h>
#include <sys/types.h>
#include <sysadm/privdefs.h>

#define SaPRIVDB CONFIG_SYSADM_VAR_DIR "/privilege"
#define SaPRIVLOCK CONFIG_SYSADM_VAR_DIR "/.privlock"
#define SaPRIVDEFDIR CONFIG_SYSADM_DEFAULTPRIVILEGES_DIR
#define SaPRIVUSERDB CONFIG_SYSADM_VAR_DIR "/privilegedUsers"    
#define SaPRIVUSERLOCK CONFIG_SYSADM_VAR_DIR "/.privUserLock"
#define SaPRIVCMDDIR CONFIG_SYSADM_PRIVBIN_DIR
#define SaPRIVCHKCONFIG CONFIG_SYSADM_ETC_CONFIG_DIR "/privileges"

#define SaPRIVHOME CONFIG_SYSADM_VAR_DIR "/privhome"
#define SaPRIVENV CONFIG_SYSADM_VAR_DIR "/privenviron"

typedef struct _SaPrivFile SaPrivFile;

typedef struct _SaPrivent {
    char *privilege;
    const char **users;
    int numUsers;
} SaPrivEnt;

SaPrivFile *SaOpenPrivDB(void);
const SaPrivEnt *SaGetPrivEnt(SaPrivFile *privFile);
const SaPrivEnt *SaLookupPrivEnt(SaPrivFile *privFile, const char *privilege);
void SaClosePrivDB(SaPrivFile *privFile);

/*
 * The difference between SaHasPrivInDB and SaCheckPriv:
 *   SaHasPrivInDB simply does the lookup in the privilege database to see
 *   if the requested privileges are OK.
 * 
 *   SaCheckPriv also considers things like whether the current user
 *   happens to be root or maybe there's no root password (in which
 *   case everybody is privileged), as well as default privileges and
 *   privileged users.
 */
bool SaHasPrivInDB(const char *user, const char * const *privs,
			unsigned int nPrivs);

SaPrivResult SaCheckPriv(uid_t uid, const char * const *privs,
			 unsigned int nPrivs);

/*
 * Callers of SaCheckPriv don't need to worry about default privileges
 * and privileged users; SaCheckPriv takes of checking that.  These
 * are here for clients who care about the difference (such as rmpriv).
 */
bool SaIsDefaultPrivilege(const char *privilege);
bool SaIsPrivilegedUser(const char *loginName);

/*
 * SaPrivilegesAreEnabled returns B_FALSE if privileges are
 * chkconfig'd off.
 */
bool SaPrivilegesAreEnabled(void);

/*
 * SaPrivCheckFile() makes sure that "fileName" and the directory it's
 * in are owned by root and only writable by root.  If the directory
 * is owned or writable by a user other than root SaPrivCheckFile
 * exits.  The privilege admin commands use this to defend themselves
 * against hackers.
 */
void SaPrivCheckFile(const char *fileName);

/*
 * SaPrivAuthenticate() does authentication handshaking over stdin and
 * stdout.
 */
bool SaPrivAuthenticate(const char *authScheme);

/*
 * SaPrivFixUmask sets the umask to a reasonable value.
 */
void SaPrivFixUmask(void);

/*
 * Verify a privilege name.  This function exits if "privName" is
 * bogus.  If SaPrivVerifyPrivName thinks the user is trying to spoof
 * us, it exits with no error message.
 */
void SaPrivValidatePrivName(const char* privName);

#ifdef __cplusplus
}
#endif
#endif /* _PRIVILEGE_H_ */
