/*
 * lookup.c
 *
 *	Test the SaLookupPrivEnt functionality of libprivilege
 *
 *
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License as
 *  published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.7 $"

#include <stdio.h>
#include <stdlib.h>
#include <sysadm/privilege.h>

extern char * _SaPrivDB;

/*
 * Lookup the specified privilege entry, and print it to stdout.  Test
 * driver checks to see if we got the right stuff.
 */
void main(int argc, char *argv[])
{
    SaPrivFile *privFile;
    const SaPrivEnt *ent;
    int i;

    if (argc != 2) {
	(void)fprintf(stderr, "usage: %s <privilege>\n", argv[0]);
	exit(1);
    }

    _SaPrivDB = "./test.priv";

    privFile = SaOpenPrivDB();

    if (privFile == NULL) {
	perror(_SaPrivDB);
	exit(1);
    }

    ent = SaLookupPrivEnt(privFile, argv[1]);

    if (!ent) {
	(void)fprintf(stderr, "%s: privilege not found.\n", argv[1]);
	exit(1);
    }

    printf("%s:", ent->privilege);
    for (i = 0; i < ent->numUsers; i++) {
	if (i != 0) {
	    putchar(',');
	}
	fputs(ent->users[i], stdout);
    }

    putchar('\n');
    
    SaClosePrivDB(privFile);
    exit(0);
}
