/*
 * leak.c
 *
 *	Test libprivilege with an empty database
 *
 *
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License as
 *  published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.7 $"

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <sysadm/privilege.h>

extern char * _SaPrivDB;

void main(void)
{
    SaPrivFile *privFile;
    struct passwd *pwd;
    const char *priv = "bogus";

    _SaPrivDB = "./empty.priv";

    /*
     * This is making sure SaClosePrivDB doesn't screw things up if
     * there are no entries in the database.
     */
    privFile = SaOpenPrivDB();
    if (!privFile) {
	(void)fprintf(stderr, "noentries: Can't open %s\n", _SaPrivDB);
	exit(1);
    }

    pwd = getpwuid(getuid());
    if (!pwd) {
	(void)fprintf(stderr, "noentries: Can't get passwd entry!\n");
	exit(1);
    }

    (void)SaHasPrivInDB(pwd->pw_name, &priv, 1);
    SaClosePrivDB(privFile);
    exit(0);
}
