#!/usr/sbin/perl
#
# Test driver for libprivilege
#
# Copyright 1995, Silicon Graphics, Inc.
# ALL RIGHTS RESERVED
# 
# UNPUBLISHED -- Rights reserved under the copyright laws of the United
# States.   Use of a copyright notice is precautionary only and does not
# imply publication or disclosure.
# 
# U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
# Use, duplication or disclosure by the Government is subject to restrictions
# as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
# in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
# in similar or successor clauses in the FAR, or the DOD or NASA FAR
# Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
# 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
# THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
# INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
# DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
# PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
# GRAPHICS, INC.
# 
#
# $Revision: 1.5 $
#

$testdb = "test.priv";
$testdbout = "testdb.out";

#
# Strip comments out of the database
#
system("sed -e '/^#/d' $testdb > $testdbout") == 0 || die "sed failed!\n";

#
# Test getent code
#
system("./getent > getent.out") == 0 || die "getent failed!\n";
system("diff -w getent.out $testdbout") == 0 || die "getent: failed\n";
print("getent: succeeded\n");

#
# Test lookup code
#
open(TESTDB, "$testdb");

while (<TESTDB>) {
    if (! /^#/) {
	@fromdb = split(/[: \t,\n]+/);
	if ($#fromdb < 0) {
	    die "lookup: failed on input from database\n";
	}
	open(LOOKUP, "./lookup $fromdb[0] |");
	($line = <LOOKUP>) || die "lookup: failed on lookup output\n";
	@fromlookup = split(/[: \t,\n]+/, $line);

	if ($#fromlookup != $#fromdb) {
	    die "lookup: failed on tokens in \"$line\"\n";
	}

	for ($i = 0; $i <= $#fromlookup; $i++) {
	    if ($fromlookup[$i] != $fromdb[$i]) {
		die "lookup: failed on token \"$fromlookup[$i]\"\n";
	    }
	}
    }
}

print("lookup: succeeded\n");

#
# Test haspriv code
#

sub hasPriv
{
    local($user, $privilege) = @_;

    open(TESTDB, $testdb);
    while (<TESTDB>) {
	if (! /^#/) {
	    @line = split(/[: \t,\n]+/);
	    if ($#line > 0 && $privilege eq $line[0]) {
		shift @line;
		foreach $userid (@line) {
		    if ($user eq $userid) {
			close(TESTDB);
			return 1;
		    }
		}
	    }
	}
    }
    close(TESTDB);
    return 0;
}

@users = ("guest", "lp", "daemon", "nobody");
@privileges = ("addUser", "deleteUser", "mountDisk", "addModem", "bogus");

foreach $user (@users) {
    foreach $priv (@privileges) {
	open(HASPRIV, "./haspriv $user $priv|");
	$line = <HASPRIV> || die "haspriv: can't run haspriv\n";
	close(HASPRIV);
	chop $line;
	$progSays = $line eq "yes";
	$weSay = &hasPriv($user, $priv);

	if ($progSays != $weSay) {
	    die "haspriv: failed on $user $priv\n";
	}
    }
}

print("haspriv: suceeded\n");

#
# Test for leaks
#
system("./leak") == 0 || die("leak: failed\n");
print("leak: succeeded\n");

#
# Test with an empty database
#
system("./noentries") == 0 || die("noentries: failed\n");
print("noentries: succeeded\n");
