/*
 * auth.h
 *
 *	#include file for authentication stuff
 *
 *
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.10 $"

#ifndef _AUTH_H_
#define _AUTH_H_
#ifdef __cplusplus
extern "C" {
#endif

#include <sysadm/sysadm.h>
#include <sys/types.h>

struct _WidgetRec;

#define SaPRIVAUTHDIR CONFIG_SYSADM_AUTHDSO_DIR

typedef struct _SaAuth SaAuth;
typedef enum { SaAuthSender, SaAuthReceiver } SaAuthType;

/*
 * Open the dso corresponding to authScheme, and create a
 * corresponding SaAuth structure.
 */
SaAuth *SaAuthOpen(const char *authScheme, SaAuthType authType);

/*
 * Close the dso corresponding to auth.
 */
void SaAuthClose(SaAuth *auth);

/*
 * Get the name of an an authentication scheme.  This returns the same
 * string ("same" meaning strcmp will be equal) that was passed to
 * SaAuthOpen.
 */
const char *SaAuthGetName(SaAuth *auth);

/*
 * Create widgets for SaPrivDialog for this particular authentication
 * scheme.  Only valid if SaAuthOpen() was called with SaAuthSender.
 */
struct _WidgetRec *SaAuthCreateWidgets(SaAuth *auth,
				       struct _WidgetRec *parent);

/*
 * Initialize widgets for SaPrivDialog just prior to the dialog being
 * displayed.  Only valid if SaAuthOpen() was called with SaAuthSender.
 */
void SaAuthInitWidgets(SaAuth *auth);

/*
 * Send authentication parameters.  To support challenge/response
 * interactions, outfd should be used to send responses and infd
 * should be used to receive challenges.  Only valid if SaAuthOpen()
 * was called with SaAuthSender.
 */
void SaAuthSendParams(SaAuth *auth, int infd, int outfd);

/*
 * Check authentication parameters sent by SaAuthSendParams.  Use infd
 * to get responses sent by SaAuthSendParams, and outfd to send
 * challenges.  Only valid if SaAuthOpen() was called with
 * SaAuthReceiver.
 */
bool SaAuthCheckParams(SaAuth *auth, int infd, int outfd);

#ifdef __cplusplus
}
#endif
#endif /* _AUTH_H_ */
