/*
 * authproto.h
 *
 *	prototypes for functions to be defined in an authentication
 *	scheme dso.
 *
 *
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.7 $"

#ifndef _AUTHPROTO_H_
#define _AUTHPROTO_H_
#ifdef __cplusplus
extern "C" {
#endif

#include <sysadm/sysadm.h>
#include <sys/types.h>

struct _WidgetRec;

/*
 * When writing an auth dso, define "struct _auth" to contain
 * whatever data you need to keep track of during execution.  This is
 * here to avoid the need for global variables.
 */
typedef struct _auth AUTH;

/*
 * If Open is called with AUTH_SENDER, a call to Createidgets followed
 * by a call to InitWidgets followed by a call to SendParams is to be
 * expected.  If Open is called with AUTH_RECEIVER, a call to
 * CheckParams is to be expected.
 */
typedef enum { AUTH_SENDER, AUTH_RECEIVER } AuthType;
AUTH *Open(const char *authScheme, AuthType authType);

/*
 * Create some widgets to become a part of the SaPrivDialog dialog
 * box.  parent is an XmRowColumn widget.  The widget returned by this
 * function will appear in between the introductory text and the
 * toggle buttons on the SaPrivDialog dialog box.
 */
struct _WidgetRec *CreateWidgets(AUTH *auth, struct _WidgetRec *parent);

/*
 * This gets called right before the SaPrivDialog dialog box is
 * displayed, either for the first time or a subsequent time.  It
 * gives the auth dso a chance to initialize its widgets.
 */
void InitWidgets(AUTH *auth);

/*
 * Send authentication parameters as specified by the widgets that
 * were created by CreateWidgets.  If further interaction is necessary
 * here, it's OK to bring up a subsequent dialog.
 */
void SendParams(AUTH *auth, int infd, int outfd);

/*
 * Check that the parameters sent by SendParams are valid.  Return
 * B_TRUE if they're valid, B_FALSE if they're not.  This function
 * should test isatty(infd); it's possible CheckParams is
 * interacting with the user through a tty as opposed to through motif
 * widgets.  In this case, prompts should be printed to the user (via
 * /dev/tty) and then echo should be turned off when the user types
 * sensitive stuff.
 * 
 * If !isatty(infd), then infd and outfd should be file descriptors
 * for communicating with a GUI program, and SendParams will be at the
 * other end of the socket.
 */
bool CheckParams(AUTH *auth, int intfd, int outfd);

/*
 * Called when authentication dso is no longer needed.  Any memory
 * pointed to by auth should be freed, widgets should be destroyed,
 * file descriptors should be closed, etc.
 */
void Close(AUTH *auth);

#ifdef __cplusplus
}
#endif
#endif /* _AUTHPROTO_H_ */
