/*
 * logerror.c
 *
 *	Dealing with error messages from the system admin logging
 *	facility.
 *
 *
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.10 $"

#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sysadm/salogI.h>
#include <sysadm/i18n.h>

/*
 * errorCode accessor.
 */
SaLogErrorCode SaLogGetErrorCode(SaLog *log)
{
    return log->errorCode;
}

/*
 *  const char *SaLogErrorCodeToString(SaLogErrorCode errorCode)
 *
 *  Description:
 *      Translate an error code into a human-readable string.
 *
 *  Parameters:
 *      errorCode  The error code to look up.
 *
 *  Returns:
 *	An error string.  This function is guaranteed not to return NULL.
 */
const char *SaLogErrorCodeToString(SaLogErrorCode errorCode)
{
    static char buf[80];
    if (errorCode == SaLogErrSys) {
	return strerror(errno);
    }
    switch (errorCode) {
        case SaLogErrNoError:
            return i18n("No error");
        case SaLogErrNoMem:
            return i18n("Out of memory");
        case SaLogErrCantLock:
            return i18n("Unable to lock system administration log");
        /*   SaLogErrSys is handled above by strerror() */
    }
    snprintf(buf, sizeof(buf), i18n("Error code %d"), errorCode);
    return buf;
}

/*
 *  const char *SaLogGetErrorString(SaLog *log)
 *
 *  Description:
 *      Get a human-readable error message describing the last SaLog
 *      function that failed.
 *
 *  Parameters:
 *      log  SaLog handle.
 *
 *  Returns:
 *	An error string.  This function is guaranteed not to return NULL.
 */
const char *SaLogGetErrorString(SaLog *log)
{
    if (log->errorCode == SaLogErrSys && log->errorString) {
	return log->errorString;
    }
    return SaLogErrorCodeToString(log->errorCode);
}
