/*
 * salogI.h
 *
 *	Internal (private) header file for libsalog.
 *
 *
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.10 $"

#ifndef _SALOGI_H_
#define _SALOGI_H_
#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <sysadm/salog.h>

struct _SaLog {
    FILE *fp;
    SaLogErrorCode errorCode;
    const char *errorString;
    pid_t pid;
    uid_t uid;
    char *host;
    char *command;
    bool logToSysLog;
    bool perrorFlag;
    int rotLockFd;
};

/*
 * System Administraton logs.  log gets rotated periodically to oldlog.
 */
#define SaLOGFILE CONFIG_SYSADM_VAR_DIR "/salog"
#define SaLOGFILEOLD CONFIG_SYSADM_VAR_DIR "/oldsalog"

#define SaLOGCONFIG CONFIG_SYSADM_VAR_DIR "/salog.conf"

/*
 * Lock file used to mediate access to log rotation.
 */
#define SaLOGROTLOCK CONFIG_SYSADM_VAR_DIR "/.salogrot.lock"

/*
 * Maximum line size that will get written to the log.
 */
#define SaLOGBUFSIZE 2048

/*
 * Default number size of log in bytes before rotation.  This is
 * overridden by the "rotsize=" line in SaLOGCONFIG.
 */
#define SaLOGROTSIZE (1024 * 1024)
#define SaLOGMINROTSIZE (5 * 1024)

/*
 * These are here for testing purposes.  Test programs can set these
 * variables to control which files are used for logging.
 */
extern const char *_SaLogFile;
extern const char *_SaLogFileOld;
extern const char *_SaLogConfig;
extern const char *_SaLogRotLock;
extern bool _SaTestLock;

#ifdef __cplusplus
}
#endif
#endif /* _SALOGI_H_ */
