#!/bin/sh

rm -f salog
./testlog

if [ $? -ne 0 ]
then
	exit 1
fi

sed -e 's/^[^;]*;\([^;]*\);.*;\([^;]*\);\([^;]*\)$/\1;\2;\3/' \
	< salog > salog.out
diff salog.out salog.expected > /dev/null 2>&1

if [ $? -ne 0 ]
then
	echo Error: salog did not match salog.expected 1>&2
	exit 1
fi


#
# Test log rotation.
#

getsize()
{
	if [ -f $1 ]
	then
		size=`ls -lgo $1 | nawk '{ print $3 }'`
	else
		size=0;
	fi
}

TestRot()
{
	echo "rotsize=$ROTSIZE" > salog.conf
	size=0;
	
	while [ ! -f oldsalog ]
	do
		getsize salog
		./testlog
		if [ $size -gt $ROTSIZE -a ! -f oldsalog ]
		then
			echo Error: Log got big w/o being rotated 1>&2
			exit 1
		fi
	done
	
	getsize salog
	logsize=$size
	getsize oldsalog
	total=`expr $size + $logsize`
	
	if [ $total -lt $ROTSIZE ]
	then
		echo Error: Log was rotated before it was big enough 1>&2
		exit 1
	fi
}

rm -f salog.conf

#ROTSIZE=1048576
#TestRot

ROTSIZE=10240
rm -f salog oldsalog salog.conf
TestRot

chmod og-r salog
rm -f oldsalog
TestRot

mode=`ls -l salog | sed -e "s/ .*//g"`
if [ "$mode" != "-rw---L---" ]
then
	echo Error: Log did not retain permissions after rotate 1>&2
	exit 1
fi

