//
// CategoryErrorEvent.h
//	
//	Represents notification of Category error.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.5 $"
#ifndef _SYSADM_CATEGORY_ERROR_EVENT_H
#define _SYSADM_CATEGORY_ERROR_EVENT_H

#include <sysadm/String.h>

BEGIN_NAMESPACE(sysadm);

class Category;

//
// A CategoryErrorEvent represents an application specific error
// encountered by Category subclasses.  The Category subclasses pass
// the localized string representing the error to
// Category::notifyError() which in turn converts it to a
// CategoryErrorEvent and notifies registered CategoryErrorListener
// instances.
//
class CategoryErrorEvent {
    
  public:
    // Constructor.  The "source" is a reference to the Category that
    // generated this event.  The "reason" is a localized string
    // describing the error.
    CategoryErrorEvent(const Category& source, const String& reason);

    // Access the Category object that generated this event.
    virtual const Category& getCategory();

    // Access the localized string describing the error.
    virtual const String& getErrorString();

    // Destructor
    virtual ~CategoryErrorEvent();

  private:

    // Intentionally undefined.	
    CategoryErrorEvent(const CategoryErrorEvent&);
    CategoryErrorEvent& operator=(const CategoryErrorEvent&);

    // Opaque implementation.
    friend class CategoryErrorEventImpl;
    CategoryErrorEventImpl* _impl;
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_CATEGORY_ERROR_EVENT_H
