//
// CategoryListener.c++
//
//	Class for monitoring changes in a Category.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.15 $"

#include <sysadm/CategoryListener.h>

BEGIN_NAMESPACE(sysadm);

class CategoryListenerImpl {
  public:
    CategoryListenerImpl() : _numCategoriesMonitored(0) { }
    int _numCategoriesMonitored;
};

//
// Do-nothing implementations of virtual methods which subclasses
// override to get notification.
//
void CategoryListener::itemAdded(const Item&) {
}

void CategoryListener::itemChanged(const Item&, const Item&) {
}

void CategoryListener::itemRemoved(const Item&) {
}

void CategoryListener::beginBlockChanges() {
}

void CategoryListener::endBlockChanges() {
}

void CategoryListener::endExists() {
}

void CategoryListener::attrChanged(const AttrEvent&) {
}

//
// Destructor for CategoryListener class.  Needed so when Category
// destroys its list the right destructors get called.
//
CategoryListener::~CategoryListener() {
#ifndef NDEBUG
    if (_impl->_numCategoriesMonitored > 0) {
	cerr << "A CategoryListener that was still active" << endl;
	cerr << "has just been deleted" << endl;
    }
#endif
    assert(_impl->_numCategoriesMonitored == 0);
    delete _impl;
}

CategoryListener::CategoryListener()
: _impl(new CategoryListenerImpl) {
}

bool CategoryListener::isAdopted() {
    return _impl->_numCategoriesMonitored ? true : false;
}

void CategoryListener::adopt() {
    _impl->_numCategoriesMonitored++;
}

void CategoryListener::orphan() {
    _impl->_numCategoriesMonitored--;
    
    // If _numCategoriesMonitored is < 0, it probably means that the
    // listener is being removed from a Category which has already
    // been destroyed.
    assert(_impl->_numCategoriesMonitored >= 0);
}

END_NAMESPACE(sysadm);
