//
// ChildCategoryListener.h
//
//	Class for monitoring changes in child Item(s) for ComputedAssoc.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.5 $"
#ifndef _SYSADM_CHILD_CATEGORY_LISTENER_H
#define _SYSADM_CHILD_CATEGORY_LISTENER_H

#include <sysadm/CategoryListener.h>
#include <sysadm/ComputedAssoc.h>

BEGIN_NAMESPACE(sysadm);
//
// Class for monitoring changes in child Item(s) for ComputedAssoc.
// For internal use by ComputedAssoc.
//
class ChildCategoryListener : public CategoryListener {
  public:

    // For logging.
    static const char* NAME;

    // Constructor.
    ChildCategoryListener(Category& childCategory,
			  NotificationFilter* filter,
			  ComputedAssoc& assoc);

    // Destructor.
    virtual ~ChildCategoryListener();

    // Called by Category after an Item has been added or 
    // detected at startup.
    virtual void itemAdded(const Item& item);
    
    // Called by Category when an Item changes.  
    virtual void itemChanged(const Item& oldItem, const Item& newItem);

    // Called by Category when an Item is removed.
    virtual void itemRemoved(const Item& item);

    // Called by Category prior to a block of
    // changes.  For example,
    // Category::replaceItemList() calls
    // beginBlockChanges() before changing the list.
    virtual void beginBlockChanges();

    // Called by Category after a block of changes.
    virtual void endBlockChanges();

    // Called by Category after notification of current state.
    virtual void endExists();

    // Called by Category after a Category attribute
    // has been added or detected at startup
    virtual void attrChanged(const AttrEvent& event);

    // Recomputes the list of children based on the child items that
    // match filter. Changes filter associated with the listener on 
    // child category items.
    virtual void adoptAndReplaceNotificationFilter(NotificationFilter*
						   filter);

  private:
    
    ComputedAssoc& _assoc;
    Category& _cat;
    CategoryListenerHandle* _handle;

    // Reqd to change the list of items in the association 
    // based on filter specified.
    bool _receivingNewList;
    long _skipEndBlockChanges;
    ItemList _newList;
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_CHILD_CATEGORY_LISTENER_H
