//
// Item.c++
//
//	A monitored object within a Category.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.7 $"
#include <sysadm/Item.h>
#include <string.h> 

BEGIN_NAMESPACE(sysadm);

// Constructor
Item::Item(const String& type, const String& selector) :  
    AttrBundle(type, selector) {
     
}

// Constructor
Item::Item(const String& stream):  AttrBundle(stream)  {
}

// Destructor
Item::~Item() {
}

//
//  int Item::compare(const Item& other) const
//
//  Description:
//      Compare two Items.  This is used by Category for
//      sorting lists of items.
//
//  Parameters:
//      other  Item to compare.
//
//  Returns:
//	< 0 if this < other, 0 if this == other, > 0 if this > other.
//
int Item::compare(const Item& other) const {
    return strcmp(getSelector(), other.getSelector());
}


//
//  Item* Item::clone() const
//
//  Description:
//      Create a copy of this Item.
//
//  Returns:
//	A copy of this Item.
//
AttrBundle* Item::clone() const {
    return new Item(*this);
}

//
//  DictionaryOf<String>* Item::createStringSequence(
//               const String& numKeysAttr,const String& key) const
//
//  Description:
//      Creates a  dictionary of strings corresponding to the specified 
// 	attribute keys.
//
//  Parameters:
//	numKesAttr  Key of the attribute which contains the number of keys.
//      key         The key of the attribute that corresponds to a
//                  string sequence.
//
//  Returns:
//	Dictionary of strings.
//
DictionaryOf<String>* Item::createStringSequence(const String& numKeysAttr,
						 const String& key) const {
    DictionaryOf<String>* seq = new DictionaryOf<String>();
    Attribute attr = getAttr(numKeysAttr);
    
    if (attr != Attribute::NUL) {
	int numKeys = attr.getValueString().asLong();
	int numKeysCopy = numKeys;

	short count = 0;
	while (numKeys) {
	    numKeys /= 10;
	    count++;
	}
	count += strlen(key);
	char buf[count+1];

	for (int ii = 0 ; ii < numKeysCopy ; ii++) {
	    sprintf(buf, "%s%d", (const char*) key, ii);
	    Attribute valueAttr = getAttr(buf);
	    assert(valueAttr != Attribute::NUL);
	    String* valueClone = new String(valueAttr.stringValue());
	    seq->add(valueClone, valueClone);
	}
    }

    return seq;
}

//
//  void Item::destroyStringSequence(DictionaryOf<String>* seq) 
//
//  Description:
//      Free the memory associatied with the dictionary of strings
//      previously obtained via createStringSequence.
//
//  Parameters:
//      seq The variable to free.
//
void Item::destroyStringSequence(DictionaryOf<String>* seq) 
{
    DictionaryOfIterator<String> iter(seq);
    while (iter() != NULL) {
	iter.remove();
    }
    delete seq;
}

END_NAMESPACE(sysadm);
