//
// NotificationFilter.h
//
//	Class for specifying types of notifications that a
//	CategoryListener wants to receive
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.10 $"
#ifndef _SYSADM_NOTIFICATION_FILTER_H
#define _SYSADM_NOTIFICATION_FILTER_H

#include <sysadm/String.h>

BEGIN_NAMESPACE(sysadm);

//
// A NotificationFilter object specifies either an entire Category or a
// subset of Items within a Category to be monitored.  It can also
// specify monitoring of changes of the attributes of the Category.
//
// See Category.h for more details on the use of NotificationFilter(s).

class NotificationFilter {

  public:

    // Constructor.
    NotificationFilter();
    
    // Copy Constructor.
    NotificationFilter(const NotificationFilter& filter);

    // Destructor.
    virtual ~NotificationFilter();
    
    // Register interest in Item named by "selector".
    // Any prior call to monitorAllItems() for this 
    // NotificationFilter is no longer in effect.
    virtual void monitorItem(const String& selector);

    // Unregister interest in Item named by "selector".
    // It is an error to call this method if a 
    // monitorAllItems() call is in effect.
    virtual void unmonitorItem(const String& selector);

    // Register interest in all Items in Category.
    virtual void monitorAllItems();

    // Unregister interest in all Items in Category.
    virtual void unmonitorAllItems();

    // Register interest in all Category attributes.
    virtual void monitorCategoryAttrs();

    // Unregister interest in all Category attributes.
    virtual void unmonitorCategoryAttrs();

    // Determine if the filter monitors specified item
    virtual bool monitorsItem(const String& selector);

    // Determine if the filter monitors category attributes
    virtual bool monitorsCategoryAttrs();

    // Create a copy of this NotificationFilter.
    NotificationFilter* clone() const;

  private:

    // Intentionally undefined.    
    NotificationFilter& operator=(const NotificationFilter&);

    // Opaque implementation.
    friend class NotificationFilterImpl;
    NotificationFilterImpl* _impl;
};


END_NAMESPACE(sysadm);

#endif  //  _SYSADM_NOTIFICATION_FILTER_H
