//
// ExampleCategory.c++
//
//	Example category class.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.13 $"

#include <sysadm/ExampleCategory.h>
#include <sysadm/Log.h>
#include <sysadm/i18n.h>
#include <unistd.h>

BEGIN_NAMESPACE(sysadm);

SaCATEGORY_REF_DEF(ExampleCategory);

END_NAMESPACE(sysadm);

USING_NAMESPACE(sysadm);

const char* ExampleCategory::NAME = "Example";
const char* ExampleCategory::CATEGORY_SERVICE = "category";

//
// Implementation of ExampleCategory.  Stays hidden from clients.
//
class sysadm::ExampleCategoryImpl {

  public:

    // Constructor.
    ExampleCategoryImpl(ExampleCategory *exampleAlias);

    // Destructor.
    ~ExampleCategoryImpl();

    // Deal with an example that some entity told us has come into existence.
    enum NewReason { Add, Exists, Changed };
    void handleNewItem(NewReason newReason, const char *exampleName);


    ExampleCategory *_exampleCategory;

};

ExampleCategoryImpl::ExampleCategoryImpl(ExampleCategory
					 *exampleAlias) :
    _exampleCategory (exampleAlias) {
}

ExampleCategoryImpl::~ExampleCategoryImpl() {
}

//
// Constructor.
//
ExampleCategory::ExampleCategory()
: Category("ExampleCategory"), _impl(new ExampleCategoryImpl(this)) {
}

//
// Destructor.
//
ExampleCategory::~ExampleCategory() {
    delete _impl;
}

void ExampleCategory::startMonitor() {

    Log::debug(CATEGORY_SERVICE, i18n("Started Monitor in category %s."),
	       NAME);

    Item item("Example", "ExampleName1");
    item.setAttr(Attribute("username", "one"));
    item.setAttr(Attribute("age", "really old!"));
    _impl->_exampleCategory->addItem(item);

    _impl->_exampleCategory->setAttr(Attribute("TESTCategoryAttr",
					       "TESTCategoryAttr"));

    Item item1("Example", "ExampleName2");
    item1.setAttr(Attribute("username", "two"));
    item1.setAttr(Attribute("age", "really cool!"));
    _impl->_exampleCategory->addItem(item1);

    _impl->_exampleCategory->endExists();
    item.setAttr(Attribute("age", "really young!"));
    _impl->_exampleCategory->changeItem(item);

    sleep(10);

    _impl->_exampleCategory->changeItem(item);

    sleep(10);

    item.setAttr(Attribute("age", "really cool!"));
    _impl->_exampleCategory->changeItem(item);

    sleep(10);

    _impl->_exampleCategory->removeItem("ExampleName1");
    
    sleep(10);

    _impl->_exampleCategory->setAttr(Attribute("name", " Example"));
    
    sleep(10);
				     
    //_impl->handleNewItem(ExampleCategoryImpl::Add, "ExampleName1");
    //_impl->handleNewItem(ExampleCategoryImpl::Changed, "ExampleName1");
    //_impl->handleNewItem(ExampleCategoryImpl::Add, "ExampleName2");
    //_impl->_exampleCategory->orphanDeletedItem("ExampleName1");

}

void ExampleCategoryImpl::handleNewItem(NewReason newReason,
					const char *itemName) {
    
    // Find all attributes associated with itemName
    
    Item* item = new Item("Example", itemName);
    item->setAttr(Attribute("attr1", "attr1"));
    item->setAttr(Attribute("attr2", "attr2"));

    switch (newReason) {
    case Add:
	_exampleCategory->addItem(*item);
	break;
    case Changed:
	_exampleCategory->changeItem(*item);
	break;
    }

}
