//
// ExampleClass.h
//
//	Example Category Class.  Adds and Deletes "examples".
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.6 $"

#ifndef _SYSADM_EXAMPLE_CATEGORY_H
#define _SYSADM_EXAMPLE_CATEGORY_H

#include <sysadm/Category.h>
#include <sysadm/CategoryFactory.h>

BEGIN_NAMESPACE(sysadm);

//
// ExampleCategory objects are accessed through their
// corresponding ObjRefs.
//
SaCATEGORY_REF_DECL(ExampleCategory);

class ExampleCategory : public Category {

  public: 

    static const char* CATEGORY_SERVICE;
    static const char* NAME;

    // Start monitoring the system.
    virtual void startMonitor();
    
  protected:

    // Allow CategoryFactory to create us.
    SaCATEGORY_FRIEND_DEF(ExampleCategory);

    // Constructor
    ExampleCategory();

    // Destructor
    virtual ~ExampleCategory();

  private:

    // Intentionally undefined.
    ExampleCategory(const ExampleCategory&);
    ExampleCategory& operator=(const ExampleCategory&);

    // Opaque implementation.
    friend class ExampleCategoryImpl;
    ExampleCategoryImpl *_impl;
};
    
END_NAMESPACE(sysadm);

#endif  //  _SYSADM_EXAMPLE_CATEGORY_H
