//
// MachinesAssocWithCluster.h
//
//	Association Class representing the relationship between an item
//	of type Cluster and item(s) of type Machine.  
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.5 $"
#ifndef _SYSADM_MACHINES_ASSOC_WITH_CLUSTER_H
#define _SYSADM_MACHINES_ASSOC_WITH_CLUSTER_H

#include <sysadm/ParentAttrAssoc.h>
#include <sysadm/String.h>
#include <sysadm/AssocFactory.h>

BEGIN_NAMESPACE(sysadm);
//
// MachinesAssocWithCluster objects are accessed through their
// corresponding AssocRefs.
//
SaASSOC_REF_DECL(MachinesAssocWithCluster);

class MachinesAssocWithCluster : public ParentAttrAssoc {

  protected:
    MachinesAssocWithCluster(Category& parentCategory,
			     const String& parentSelector,
			     Category& childCategory);
 
    // Allow AssocFactory to create us.
    SaASSOC_FRIEND_DEF(MachinesAssocWithCluster);
};


END_NAMESPACE(sysadm);
#endif  //  _SYSADM_MACHINES_ASSOC_WITH_CLUSTER_H
