//
//  Copyright (c) 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2 of the GNU General Public License as
//  published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
#include <sysadm/ExampleCategory.h>
#include <sysadm/CategoryListener.h>
#include <sysadm/NotificationFilter.h>

#include <stdio.h>
#include <limits.h>
#include <dlfcn.h>
#include <getopt.h>

#include <iostream.h>
#include <sysadm/CategoryFactory.h>
#include <sysadm/Log.h>
#include <sysadm/AppContext.h>

USING_NAMESPACE(sysadm);

static bool gExit = true;

class ExampleCategoryListener : public CategoryListener {
    virtual void itemAdded(const Item& item) {
	printItem("ADDED", item);
    }
    virtual void itemChanged(const Item&, const Item& newItem) {
	printItem("CHANGED", newItem);
    }
    virtual void itemRemoved(const Item& item) {
	printItem("DELETED", item);
    }
    virtual void endExists() {
	if (gExit) {
	    exit(0);
	}
    }
    virtual void attrChanged(const AttrEvent& event) {
	Attribute attr(event.getChangedAttr());
	printf("attr: %s=%s\n", (const char*)attr.getKey(),
	       (const char*)attr.getValueString());
    }
    void printItem(const char* prefix,  const Item& item) {
	printf("%s: %s:\n", prefix, (const char*)item.getSelector());
	CollectionOf<Attribute> attrs(item.copyAttrList());
	IteratorOver<Attribute> iter(&attrs);
	Attribute* attr;
	int maxKeyWidth = 0;
	while ((attr = iter()) != NULL) {
	    int keyWidth = attr->getKey().getLength();
	    if (keyWidth > maxKeyWidth) {
		maxKeyWidth = keyWidth;
	    }
	}
	iter.reset();
	char formatString[100];
	sprintf(formatString, "    %%-%ds : %%s\n", maxKeyWidth);
	while ((attr = iter()) != NULL) {
	    printf(formatString, (const char*)attr->getKey(),
		   (const char*)attr->getValueString());
	}
    }
};

void usage() {
    fprintf(stderr, "usage: testCategory [ -f ]\n");
    exit(1);
}

int
main(int argc, char *argv[]) {
    String errorString;
    Category* eCategory = CategoryFactory::getCategory("ExampleCategory",
						       errorString);
    
    int c;
    while ((c = getopt(argc, argv, "f")) != EOF) {
	switch (c) {
	case 'f':
	    gExit = false;
	    break;
	default:
	    usage();
	    break;
	}
    }

    if (eCategory != NULL) {
	cout << eCategory->getType() << endl;
	cout << eCategory->getSelector() << endl;

	CategoryListener* listener = new ExampleCategoryListener();
	NotificationFilter filter;
	filter.monitorAllItems();
	filter.monitorCategoryAttrs();
	CategoryListenerHandle* handle = 
	    eCategory->adoptCategoryListener(listener, filter);
	AppContext::getAppContext().run();
    } else {
	cerr << (const char*) errorString;
    }

/*
    



    CategoryListenerHandle* h = eCategory->adoptCategoryListener(listener1);
    eCategory->adoptNotificationFilter(h, filter);
    
    CategoryListener* listener2 = 
        new CategoryListener();
    CategoryListenerHandle* h2 = eCategory->adoptCategoryListener(listener2);
    NotificationFilter* filter2 = new NotificationFilter();
    eCategory->adoptNotificationFilter(h2, filter2);

    eCategory->removeCategoryListener(h);
    eCategory->removeCategoryListener(h2);
*/
}


