//
// Connection.h
//
//	Base class for Connection to our peer.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ifndef _SYSADM_CONNECTION_H
#define _SYSADM_CONNECTION_H
#ident "$Revision: 1.7 $"

#include <sysadm/Packet.h>
#include <sysadm/PacketListener.h>
#include <sysadm/DictionaryOf.h>

BEGIN_NAMESPACE(sysadm);

//
// Connection is an abstract class that provides an interface for
// sending Packets and receiving Packets.  A subclass must provide
// a sendPacket() method, and must call distributePacket() whenever a
// packet arrives.
//
class Connection {
  public:

    // For logging.
    static const char CONNECTION_SERVICE[];

    // Constructor.
    Connection();

    // Destructor.
    virtual ~Connection();

    // Send a packet.
    virtual void sendPacket(const Packet& packet) = 0;

    // Get the name of the host at the other end of the connection.
    virtual String remoteHostName();

    virtual void setRemoteHostName(const String& host);

    // "listener"'s receivePacket() method will be called whenever a
    // packet is received which has a type of "type".  Only one
    // listener at a time can be installed for a given "type".
    virtual void adoptPacketListener(const String& type,
				     PacketListener* listener);

    // Remove the PacketListener for "type".
    virtual PacketListener* orphanPacketListener(const String& type);

  protected:

    // distributePacket() finds the PacketListener for this type of
    // Packet and calls its receivePacket() method.
    virtual void distributePacket(const Packet& packet);

  private:

    String _remoteHost;

    // Intentionally undefined.
    Connection(const Connection&);
    Connection& operator=(const Connection&);    

    DictionaryOf<PacketListener> _listeners;
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_CONNECTION_H
