//
// Packet.c++
//
//	Unit of communication across a connnection.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.3 $"

#include <sysadm/Packet.h>

BEGIN_NAMESPACE(sysadm);

//
// Packet constructors.
//
Packet::Packet(const String& type, const String& selector)
: AttrBundle(type, selector), _data(NULL), _dataLength(0)
{
}

Packet::Packet(const String& stream)
: AttrBundle(stream), _data(NULL), _dataLength(0)
{
}

//
//  void Packet::setData(void* data, size_t length)
//
//  Description:
//      Set the data for this packet.
//
//  Parameters:
//      data    Data for this packet.
//      length  Number of bytes.
//
void Packet::setData(void* data, size_t length)
{
    _data = data;
    _dataLength = length;
}

//
//  const void* Packet::getData() const
//
//  Returns:
//	Data for this packet.
//
const void* Packet::getData() const
{
    return _data;
}

//
//  size_t Packet::getDataLength() const
//
//  Returns:
//	Number of bytes of data for this packet.
//
size_t Packet::getDataLength() const
{
    return _dataLength;
}

END_NAMESPACE(sysadm);
