//
// Packet.h
//
//	Declaration of Packet class for sending messages across the
//	network. 
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ifndef _SYSADM_PACKET_H
#define _SYSADM_PACKET_H
#ident "$Revision: 1.4 $"

#include <sysadm/AttrBundle.h>

BEGIN_NAMESPACE(sysadm);

//
// Packet is the unit of communication when using a Connection.  A
// packet has a type, which represents a service, and a selector,
// which represents an operation within that service.  Most
// information in a packet is contained in typed/key value pairs,
// which Packet inherits from AttrBundle.
//
// A Packet can be used to send and receive arbitrary data using the
// setData() and getData() methods.  A packet that has data associated
// with it via setData() cannot be transmitted across the network in a
// byte-order independent manner, however, so this facility should
// only be used when the data being transported can be interpreted
// independently of byte-order.
//
class Packet : public AttrBundle {
  public:

    // Constructor for creating a new packet from scratch.
    Packet(const String& type, const String& selector);

    // Constructor for creating a packet from a serialized attribute
    // bundle.
    Packet(const String& stream);

    // Set data for this packet.  The data is not freed by the
    // packet's destructor.
    virtual void setData(void* data, size_t length);

    // Get the data for this packet.  The return value is owned by the
    // creator of this packet, and should not be assumed to be valid
    // beyond the lifetime of this packet.
    virtual const void* getData() const;

    // Get the number of bytes of data.
    virtual size_t getDataLength() const;

  private:

    // Intentionally undefined.
    Packet(const Packet&);
    Packet& operator=(const Packet&);

    void* _data;
    size_t _dataLength;
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_PACKET_H
