//
// RemoteShellConnection.c++
//
//	RemoteShellConnection reads and writes byte streams on a
//	pair of file descriptors.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.3 $"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <unistd.h>

#include <sysadm/io.h>
#include <sysadm/RemoteShellConnection.h>
#include <sysadm/AppContext.h>

BEGIN_NAMESPACE(sysadm);

//
// RemoteShellConnection constructor.
//
RemoteShellConnection::RemoteShellConnection(int fdIn, int fdOut)
: _fdIn(fdIn), _fdOut(fdOut)
{
    AppContext& app(AppContext::getAppContext());
    _monitor = app.registerMonitor(_fdIn, monitorCallback, this);
}

//
// RemoteShellConnection destructor.
//
RemoteShellConnection::~RemoteShellConnection()
{
    AppContext& app(AppContext::getAppContext());
    app.unregisterMonitor(_monitor);
    ::close(_fdIn);
    ::close(_fdOut);
}


//
//  void RemoteShellConnection::sendData(const void* data, size_t nbytes)
//
//  Description:
//      Send data to our peer.
//
//  Parameters:
//      data    The data to send.
//      nbytes  The number of bytes to send.
//
void RemoteShellConnection::sendData(const void* data, size_t nbytes)
{
    if (SaWriteFully(_fdOut, data, nbytes) == -1) {
	perror("SaWriteFully");
	exit(1);
    }
}

//
//  ssize_t RemoteShellConnection::receiveData(void* data, size_t nbytes)
//
//  Description:
//      Receive data from our peer.
//
//  Parameters:
//      data    Buffer to read data into.
//      nbytes  Maximum number of bytes to read.
//
//  Returns:
//	The actual number of bytes read.
//
ssize_t RemoteShellConnection::receiveData(void* data, size_t nbytes)
{
    return SaRead(_fdIn, data, nbytes);
}


//
//  void RemoteShellConnection::monitorCallback(void* clientData, int, int)
//
//  Description:
//      Called by AppContext when some input is available on our
//      socket.
//
//  Parameters:
//      clientData   Connection* (this is a static method)
//
void RemoteShellConnection::monitorCallback(void* clientData, int, int)
{
    ((RemoteShellConnection*)clientData)->handleInput();
}

END_NAMESPACE(sysadm);
