//
// SocketConnection.h
//
//	ByteStreamConnection subclass that reads and writes byte
//	streams on sockets.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.5 $"

#include <sysadm/ByteStreamConnection.h>

BEGIN_NAMESPACE(sysadm);

//
// SocketConnection is a subclass of ByteStreamConnection that reads
// and writes bytes to/from a socket.
//
class SocketConnection : public ByteStreamConnection {

  public:

    // Constructor.  SocketConnection() assumes ownership of "sock",
    // meaning that it will be closed in ~SocketConnection().
    SocketConnection(int sock);

    // Destructor.
    ~SocketConnection();

    // Get the name of the host at the other end of the connection.
    virtual String remoteHostName();

  protected:

    // Send data to our peer.
    virtual void sendData(const void* data, size_t nbytes);

    // Receive data from our peer.
    virtual ssize_t receiveData(void* data, size_t nbytes);

  private:

    // Called when some input is available.
    static void monitorCallback(void* clientData, int id, int fd);

    int _sock;
    int _monitor;
};

END_NAMESPACE(sysadm);
