//
// testConnection.c++
//
//	Test the Connection class.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2 of the GNU General Public License as
//  published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.4 $"

#include <sys/types.h>
#include <sys/socket.h>

#include <unistd.h>

#include <sysadm/SocketConnection.h>
#include <sysadm/OrderedCollectionOf.h>
#include <sysadm/AppContext.h>

USING_NAMESPACE(sysadm);

class ServerListener : public PacketListener {
  public:
    ServerListener(Connection& conn)
    : _conn(conn)
    {
    }
    
    virtual void receivePacket(const Packet& packet)
    {
	_conn.sendPacket(packet);
	if (packet.getSelector() == "quit") {
	    exit(0);
	}
    }

    Connection& _conn;
};

class ClientListener : public PacketListener {
  public:
    ClientListener(Connection& conn)
    : _conn(conn)
    {
	Packet* packet = new Packet("test", "start");
	packet->setAttr(Attribute("name", "rogerc"));
	packet->setAttr(Attribute("uid", (long long)3099L));
	packet->setAttr(Attribute("female", false));
	packet->setAttr(Attribute("double", 1.2345));
	_packets.append(packet);

	packet = new Packet("test", "next");
	packet->setAttr(Attribute("composer", "Bach"));
	packet->setAttr(Attribute("style", "baroque"));
	packet->setAttr(Attribute("century", (long long)1700L));
	packet->setAttr(Attribute("play", true));
	_packets.append(packet);

	packet = new Packet("test", "quit");
	_packets.append(packet);

	_iter = new IteratorOver<Packet>(&_packets);
	sendNextPacket();
    }
    
    virtual void receivePacket(const Packet& packet)
    {
	cout << packet.serialize() << endl;
	if (packet.getSelector() == "quit") {
	    exit(0);
	}
	sendNextPacket();
    }

    void sendNextPacket()
    {
	Packet* packet = _iter->operator()();
	if (packet != NULL) {
	    _conn.sendPacket(*packet);
	}
    }

    Connection& _conn;
    OrderedCollectionOf<Packet> _packets;
    IteratorOver<Packet>* _iter;
};

static void RunServer(int sock)
{
    SocketConnection conn(sock);
    conn.adoptPacketListener("test", new ServerListener(conn));
    AppContext::getAppContext().run();
}

static void RunClient(int sock)
{
    SocketConnection conn(sock);
    conn.adoptPacketListener("test", new ClientListener(conn));
    AppContext::getAppContext().run();
}

void main()
{
    int socks[2];
    
    if (socketpair(AF_UNIX, SOCK_STREAM, 0, socks) == -1) {
	perror("socketpair");
	exit(1);
    }

    if (fork() == 0) {
	close(socks[0]);
	RunServer(socks[1]);
    }

    close(socks[1]);
    RunClient(socks[0]);
}
