//
// FileBasedCategory.h
//
//	Base class for Categories that generate Items based on file contents.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

/*
  File description:

  Line 1:
        A sequence of name-type pairs.  The name and the type are
separated by the '!' character, and the pairs are separated by the ':'
character.  The names will be the keys of the attributes in the items,
and the type is the type of data.  Legal names consist of characters
that are not '!' or '!'.  Legal types are 'S' for
String, 'L' for Long, 'B' for boolean, and 'D' for Double.  As an
example, the line

name!S:type!S:cluster!S:machine!S:group!S:defined!S:state!L:error!L

might be the first line in the ResourceCategory.data file.

The rest of the lines:
        A selector string followed by a sequence of attribute values
separated by the ':' character.  The values will be turned into
attribute values with the type specified on Line 1.  For strings and
selectors, non ':' character are valid.  For Booleans, valid entries
are 'T' and 'F'.  Longs and Doubles are converted by using atol and
atof respectively.  For example, the line

res1:resource 1:type 1:cluster 1:machine 2:group 1:machine 1:6:0

might specify a particular item.  Notice that there is one more field
in the item line than in the description line (Line 1).  This is
because the first field ("res1" in this case) is the selector for the
item.

Use a '#' character as the first character of a line for a comment line.

*/

#ident "$Revision: 1.5 $"

#include <fam.h>
#include <sysadm/Category.h>

BEGIN_NAMESPACE(sysadm);

class FileBasedCategory : public Category {
  public:
    // Constructor.  Subclasses should pass the name of their Category
    // as "selector" and the file from which to get the items as "file"
    FileBasedCategory(const String& selector, const String& file);

    // Destructor.
    virtual ~FileBasedCategory();

    // Called when first notification filter is added.  Start famming
    // the test file.
    virtual void startMonitor();

  private:
    static void handleInput(void* clientData, int id, int fd);
    ItemList* getItemsFromFile(const char* file, const char* itemType);

    String _itemType;
    String _filename;
    String _directory;
    String _shortFilename;
    int _inputId;
    FAMConnection _famConnection;
    bool _needToCloseFAM;
};

END_NAMESPACE(sysadm);
