/*
 * exec.c
 *
 *	Test program for libsysadmParam
 *
 *
 *  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License as
 *  published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.4 $"

#include <sys/wait.h>

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

#include <sysadm/SaParam.h>

#define ARG_PREF "arg"
#define ARG_VAL "..."
#define ARG_SIZE (strlen(ARG_PREF) + strlen(ARG_VAL) + 2)

extern char **_environ;

static int EnvSize(char **env)
{
    int size = 0;
    char **p;

    for (p = env; p != NULL && *p != NULL; p++) {
	size += strlen(*p) + 1;
    }

    return size;
}    

/*
 * This is so that this program can be purified.
 */
char **CreateBiggerEnviron(void)
{
    char **newEnv, **src, **dest;
    int n;
    
    n = 0;
    for (src = _environ; *src != NULL; src++) {
	n++;
    }

    newEnv = malloc(sizeof *newEnv * (n + 2));
    
    n = 0;
    for (src = _environ, dest = newEnv; *src != NULL; src++, dest++) {
	*dest = *src;
    }

    *dest++ = "FAKE=fjdkslajfkdlsajflkdsajflkdajfs";
    *dest = NULL;
    return newEnv;
}

void SendParams(void)
{
    SaParamExecArgs *args;
    SaParam *param = SaParamCreate();
    pid_t pid;
    int pipes[2];
    int argMax = (int)sysconf(_SC_ARG_MAX);
    int numArgs = argMax / ARG_SIZE, i;
    char keyBuf[20];
    char **env;

    SaParamSet(param, "name", "rogerc");
    SaParamSet(param, "job", "programmer");
    SaParamSet(param, "age", "18");
    SaParamSetHidden(param, "passwd", "secret");
    
    for (i = 0; i < numArgs; i++) {
	sprintf(keyBuf, "%s%d", ARG_PREF, i);
	SaParamSet(param, keyBuf, ARG_VAL);
    }

    env = CreateBiggerEnviron();
    args = SaParamExecArgsCreate(param,
				 (const char* const*)env,
				 "./exec", NULL);
    free(env);

    pipe(pipes);

    pid = fork();
    if (pid == -1) {
	perror("fork");
	exit(1);
    }

    if (pid == 0) {
	char *const *argv = SaParamExecArgsGet(args);
	char **p;

	for (p = (char **)argv; *p != NULL; p++) {
	    if (strncmp(*p, "passwd", 6) == 0) {
		fprintf(stderr, "passwd wasn't hidden!\n");
		exit(1);
	    }
	}

	close(pipes[1]);
	dup2(pipes[0], 0);
	close(pipes[0]);
	execv("./exec", argv);
	perror("execv");

	i = 0;
	for (p = (char **)argv; *p != NULL; p++) {
	    i += strlen(*p) + 1;
	}
	fprintf(stderr, "argSize: %d\n", i);
	fprintf(stderr, "argMax: %d\n", argMax);
	fprintf(stderr, "envSize: %d\n", EnvSize(_environ));
	
	exit(1);
    }

    close(pipes[0]);
    if (SaParamExecArgsSendNeeded(args)) {
	SaParamExecArgsSend(args, pipes[1]);
    }

    SaParamExecArgsDestroy(args);
    SaParamDestroy(param);

    waitpid(pid, NULL, 0);
    fprintf(stderr, "Sent %d args\n", numArgs);
}

void ReceiveParams(int argc, char *argv[])
{
    SaParam *param = SaParamCreate();
    SaParamIter *iter;
    const char *key, *value;
    int i;

    if (SaParamParseArgs(param, argc, argv) == -1) {
	fprintf(stderr, "Error parsing args\n");
	for (i = 0; i < argc; i++) {
	    fprintf(stderr, "%s ", argv[i]);
	}
	fprintf(stderr, "\n");
	exit(1);
    }

    iter = SaParamIterCreate(param);
    while ((key = SaParamIterGetKey(iter)) != NULL) {
	value = SaParamIterGetValue(iter);
	printf("key: %s, value: %s\n", key, value);
    }
    SaParamIterDestroy(iter);
    SaParamDestroy(param);
}

void main(int argc, char *argv[])
{
    if (argc == 1) {
	SendParams();
    } else {
	ReceiveParams(argc, argv);
    }
    exit(0);
}
