/*
 *  Copyright (c) 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License as
 *  published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */
/*
 * Test get (and set) performance.
 */
#include <sysadm/SaParam.h>
#include <stdio.h>
#include <stdlib.h>

#define NUM_ATTRS 10000

void main(void)
{
    SaParam *param;
    int i, val, errs;
    char keyBuf[100], valBuf[100];
    const char *value;

    param = SaParamCreate();
    for (i = 0; i < NUM_ATTRS; i++) {
	sprintf(keyBuf, "key%d", i);
	sprintf(valBuf, "value%d", i);
	SaParamSet(param, keyBuf, valBuf);
    }

    errs = 0;

    /*
     * Ascending order
     */
    for (i = 0; i < NUM_ATTRS; i++) {
	sprintf(keyBuf, "key%d", i);
	value = SaParamGet(param, keyBuf);
	if (value == NULL) {
	    fprintf(stderr, "Error: value for %s missing.\n", keyBuf);
	    errs++;
	} else if (sscanf(value, "value%d", &val) != 1 || val != i) {
	    fprintf(stderr, "Error: value for %s (%s) is wrong.\n",
		    keyBuf, value);
	    errs++;
	}
    }

    /*
     * Descending order
     */
    for (i = NUM_ATTRS - 1; i >= 0; i--) {
	sprintf(keyBuf, "key%d", i);
	value = SaParamGet(param, keyBuf);
	if (value == NULL) {
	    fprintf(stderr, "Error: value for %s missing.\n", keyBuf);
	    errs++;
	} else if (sscanf(value, "value%d", &val) != 1 || val != i) {
	    fprintf(stderr, "Error: value for %s (%s) is wrong.\n",
		    keyBuf, value);
	    errs++;
	}
    }

    /*
     * Random order
     */
    for (i = 0; i < NUM_ATTRS; i++) {
	int keyNum = rand() % NUM_ATTRS;
	sprintf(keyBuf, "key%d", keyNum);
	value = SaParamGet(param, keyBuf);
	if (value == NULL) {
	    fprintf(stderr, "Error: value for %s missing.\n", keyBuf);
	    errs++;
	} else if (sscanf(value, "value%d", &val) != 1 || val != keyNum) {
	    fprintf(stderr, "Error: value for %s (%s) is wrong.\n",
		    keyBuf, value);
	    errs++;
	}
    }

    SaParamDestroy(param);
    exit(errs != 0);
}
