/*
 * mkinput.c
 *
 *	Test program for libsysadmParam
 *
 *
 *  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License as
 *  published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.3 $"

#include <sys/types.h>
#include <sys/wait.h>

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

#include <sysadm/SaParam.h>
#include <sysadm/format.h>

void main (int argc, char *argv[])
{
    SaParam *param;
    char keyBuf[20], valueBuf[20];
    int i;

    param = SaParamCreate ();
    if (param == NULL)
    {
	fprintf (stderr, "Out of memory!\n");
	exit (1);
    }

    SaParamSet (param, "name", "rogerc");
    SaParamSet (param, "uid", "3099");
    SaParamSet (param, "%key%", "%value%");
    SaParamSet (param, "=key=", "=value=");
    SaParamSet (param, "\nkey\n", "\nvalue\n");
    SaParamSet (param, "replace", "version1");
    SaParamSet (param, "replace", "version2");

    for (i = 0; i < 20; i++)
    {
	SaStringFormat (keyBuf, sizeof keyBuf, "param%d", i);
	SaStringFormat (valueBuf, sizeof valueBuf, "%d", i);
	SaParamSet (param, keyBuf, valueBuf);
    }

    SaParamSend (param, 1);
    SaParamDestroy (param);
    exit (0);
}
