/*
 * param.c
 *
 *	Test program for libsysadmParam
 *
 *
 *  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License as
 *  published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ident "$Revision: 1.3 $"

#include <sys/types.h>
#include <sys/wait.h>

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

#include <sysadm/SaParam.h>
#include <sysadm/format.h>

void main (int argc, char *argv[])
{
    SaParam *param;
    SaParamIter *iter;
    pid_t pid;
    int pipes[2], i;
    const char *key, *value;
    char keyBuf[20], valueBuf[20];

    param = SaParamCreate ();
    if (param == NULL)
    {
	fprintf (stderr, "Out of memory!\n");
	exit (1);
    }

    if (argc == 1)
    {
	SaParamSet (param, "name", "rogerc");
	SaParamSet (param, "uid", "3099");
	SaParamSet (param, "%key%", "%value%");
	SaParamSet (param, "=key=", "=value=");
	SaParamSet (param, "\nkey\n", "\nvalue\n");
	SaParamSet (param, "replace", "version1");
	SaParamSet (param, "replace", "version2");

	for (i = 0; i < 20; i++)
	{
	    SaStringFormat (keyBuf, sizeof keyBuf, "param%d", i);
	    SaStringFormat (valueBuf, sizeof valueBuf, "%d", i);
	    SaParamSet (param, keyBuf, valueBuf);
	}

	if (pipe (pipes) == -1)
	{
	    perror ("pipe");
	    exit (1);
	}

	pid = fork ();
	if (pid == -1)
	{
	    perror ("fork");
	    exit (1);
	}

	if (pid == 0)
	{
	    dup2 (pipes[0], 0);
	    close (pipes[0]);
	    close (pipes[1]);
	    
	    execl (argv[0], argv[0], "arg1=1", "arg2=2",
		   SaPARAM_INPUT_ARG, NULL);
	    perror (argv[0]);
	    exit (1);
	}

	SaParamSend (param, pipes[1]);
	close (pipes[0]);
	close (pipes[1]);
	
	waitpid (pid, NULL, 0);
    }
    else
    {
	if (SaParamParseArgs (param, argc, argv) == -1)
	{
	    fprintf (stderr, "Can't parse command line\n");
	    exit (1);
	}

	iter = SaParamIterCreate (param);
	if (iter == NULL)
	{
	    fprintf (stderr, "Out of memory!\n");
	    exit (1);
	}

	while ((key = SaParamIterGetKey (iter)) != NULL)
	{
	    value = SaParamIterGetValue (iter);
	    printf ("key: %s, value: %s\n", key, value);
	}

	value = SaParamGet (param, "name");
	if (value != NULL)
	{
	    printf ("name: %s\n", value);
	}

	for (i = 0; i < 20; i++)
	{
	    SaStringFormat (keyBuf, sizeof keyBuf, "param%d", i);
	    value = SaParamGet (param, keyBuf);
	    if (value != NULL)
	    {
		printf("key: %s, value: %s\n", keyBuf, value);
	    }
	}
    }

    SaParamDestroy (param);
    exit(0);
}
