//
//  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ifndef _SYSADM_COLLECTION_OF_I_H
#define _SYSADM_COLLECTION_OF_I_H

BEGIN_NAMESPACE(sysadm);

// Base Iterator code

template <class Type>
inline BaseIterator<Type>::BaseIterator(
    const CollectionOf<Type>* collectionAlias )
: _impl( NULL )
{
    if( collectionAlias )
       _impl = collectionAlias->_impl->createIterator();

    assert( _impl );
}

template <class Type>
inline IteratorOverImpl *BaseIterator<Type>::getImpl() const
{
    return _impl;
}

template <class Type>
inline BaseIterator<Type>::~BaseIterator()
{
    delete _impl;
}



// Const iterator code

template <class Type>
inline ConstIteratorOver<Type>::ConstIteratorOver(
				const CollectionOf<Type>* collectionAlias )
: BaseIterator<Type>(collectionAlias)
{
}

template <class Type>
inline ConstIteratorOver<Type>::~ConstIteratorOver()
{
}

template <class Type>
inline Type* ConstIteratorOver<Type>::getFirst()
{
    return (Type*)getImpl()->getFirst();
}

template <class Type>
inline Type* ConstIteratorOver<Type>::getLast()
{
    return (Type*)getImpl()->getLast();
}

template <class Type>
inline Type* ConstIteratorOver<Type>::getNext()
{
    return (Type*)getImpl()->getNext();
}

template <class Type>
inline Type* ConstIteratorOver<Type>::getPrev()
{
    return (Type*)getImpl()->getPrev();
}


template <class Type>
inline void  ConstIteratorOver<Type>::reset()
{
    getImpl()->reset();
}

template <class Type>
inline void  ConstIteratorOver<Type>::resetToEnd()
{
    getImpl()->resetToEnd();
}

template <class Type>
inline Type* ConstIteratorOver<Type>::operator()( int skipBy )
{
    return (Type*) (*getImpl())(skipBy);
}

template <class Type>
inline Type* ConstIteratorOver<Type>::operator()()
{
    return (Type*) (*getImpl())();
}



// Iterator code

template <class Type>
inline IteratorOver<Type>::IteratorOver(CollectionOf<Type>* collectionAlias )
: ConstIteratorOver<Type>( collectionAlias )
{
}

template <class Type>
inline Type* IteratorOver<Type>::remove()
{
    return (Type*)getImpl()->remove();
}

template <class Type>
inline void  IteratorOver<Type>::insertAfter( Type* element )
{
    getImpl()->insertAfter( (void *)element );
}

template <class Type>
inline void  IteratorOver<Type>::insertBefore( Type* element )
{
    getImpl()->insertBefore( (void *)element );
}


// const Casting Iterator code

template <class derivedType, class baseType>
inline 
ConstCastIteratorOver<derivedType, baseType>::ConstCastIteratorOver(
			     const CollectionOf<baseType>* collectionAlias )
: BaseIterator<baseType>(collectionAlias) 
{
}

template <class derivedType, class baseType>
inline 
ConstCastIteratorOver<derivedType, baseType>::~ConstCastIteratorOver()
{
}

template <class derivedType, class baseType>
inline derivedType* 
ConstCastIteratorOver<derivedType, baseType>::getFirst()
{
    baseType* temp = (baseType*)getImpl()->getFirst();
    while( temp && !dynamic_cast<derivedType*>(temp) )
	  temp = (baseType*)getImpl()->getNext();

    return (derivedType*)temp;
}

template <class derivedType, class baseType>
inline derivedType* ConstCastIteratorOver<derivedType, baseType>::getLast()
{
    baseType* temp = (baseType*)getImpl()->getLast();
    while( temp && !dynamic_cast<derivedType*>(temp) )
	  temp = (baseType*)getImpl()->getPrev();

    return (derivedType*)temp;
}

template <class derivedType, class baseType>
inline derivedType* ConstCastIteratorOver<derivedType, baseType>::getNext()
{
    baseType* temp = (baseType*)getImpl()->getNext();
    while( temp && !dynamic_cast<derivedType*>(temp) )
	  temp = (baseType*)getImpl()->getNext();

    return (derivedType*)temp;
}

template <class derivedType, class baseType>
inline derivedType* ConstCastIteratorOver<derivedType, baseType>::getPrev()
{
    baseType* temp = (baseType*)getImpl()->getPrev();
    while( temp && !dynamic_cast<derivedType*>(temp) )
	  temp = (baseType*)getImpl()->getPrev();

    return (derivedType*)temp;
}


template <class derivedType, class baseType>
inline void  ConstCastIteratorOver<derivedType, baseType>::reset()
{
    getImpl()->reset();
}

template <class derivedType, class baseType>
inline void  ConstCastIteratorOver<derivedType, baseType>::resetToEnd()
{
    getImpl()->resetToEnd();
}



// const Casting Iterator code

template <class derivedType, class baseType>
inline 
CastIteratorOver<derivedType, baseType>::CastIteratorOver(
    CollectionOf<baseType>* collectionAlias )
: ConstCastIteratorOver<derivedType, baseType>( collectionAlias )
{
}

template <class derivedType, class baseType>
inline derivedType* CastIteratorOver<derivedType, baseType>::remove()
{
    return (derivedType*)getImpl()->remove();
}

template <class derivedType, class baseType>
inline void  
CastIteratorOver<derivedType, baseType>::insertAfter( baseType* element )
{
    getImpl()->insertAfter( (void *)element );
}

template <class derivedType, class baseType>
inline void  
CastIteratorOver<derivedType, baseType>::insertBefore( baseType* element )
{
    getImpl()->insertBefore( (void *)element );
}


// CollectionOf Code

template <class Type>
inline CollectionOf<Type>::CollectionOf()
: _impl( new RealCollectionOfImpl() )
{
    assert( _impl != NULL );
}

template <class Type>
inline CollectionOf<Type>::CollectionOf( const CollectionOf& copy )
: _impl( copy._impl->createClone() )
{
    assert( _impl != NULL );
}

template <class Type>
inline CollectionOf<Type>::CollectionOf( CollectionOfImpl* adoptedImpl )
: _impl( adoptedImpl )
{
    assert( _impl != NULL );
}

template <class Type>
inline CollectionOf<Type>::~CollectionOf()
{
    delete _impl;
}

template <class Type>
inline CollectionOf<Type>& 
CollectionOf<Type>::operator=( const CollectionOf& copy )
{
    if( this != &copy ) {
	delete _impl;

	_impl = copy._impl->createClone();
    }

    return *this;
}

template <class Type>
inline int CollectionOf<Type>::getSize() const
{
    return _impl->getSize();
}

template <class Type>
inline void  CollectionOf<Type>::add( Type* element )
{
    _impl->add( (void *)element );
}

template <class Type> inline
Type* CollectionOf<Type>::remove( const Type& element )
{
    IteratorOver<Type> iter(this);

    Type* item = NULL;
    while( (item = iter()) != NULL ) {
	if( *item == element )
	    return iter.remove();
    }

    return NULL;
}

template <class Type> inline
Type* CollectionOf<Type>::removePointer( const Type* element )
{
    IteratorOver<Type> iter(this);

    Type* item = NULL;
    while( (item = iter()) != NULL ) {
	if( item == element )
	    return iter.remove();
    }

    return NULL;
}


template <class Type>
inline void  CollectionOf<Type>::removeAll()
{
    _impl->removeAll();
}

template <class Type>
inline CollectionOfImpl* CollectionOf<Type>::getImpl()
{
    return _impl;
}

template <class Type>
inline const CollectionOfImpl* CollectionOf<Type>::getImpl() const
{
    return _impl;
}

template <class Type> inline
void RemoveAndDestroyContentsOf( CollectionOf<Type> *collectionAlias )
{
    IteratorOver<Type> iter(collectionAlias);
    while (iter() != NULL) {
	delete iter.remove();
    }
}

template <class Type> inline
void RemoveAndDeleteContentsOf( CollectionOf<Type>
                                   * collectionAlias )
// Just another name for the RemoveAndDestroyContentsOf function
{
    RemoveAndDestroyContentsOf(collectionAlias);
}

    

template <class Type> inline
void RemoveAndDeleteArrayContentsOf( CollectionOf<Type> *collectionAlias )
{
    IteratorOver<Type> iter(collectionAlias);
    while (iter() != NULL) {
	delete[] iter.remove();
    }
}

template <class Type> inline
void RemoveAndFreeContentsOf( CollectionOf<Type> *collectionAlias )
{
    IteratorOver<Type> iter(collectionAlias);
    while (iter() != NULL) {
	free(iter.remove());
    }
}

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_COLLECTION_OF_I_H
