//
//  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ifndef _SYSADM_COLLECTIONS_I_H
#define _SYSADM_COLLECTIONS_I_H

#include <sysadm/sysadm.h>
#include <stdlib.h>

BEGIN_NAMESPACE(sysadm);

class DLink;

class CollectionOfImpl 
{
  public:
    CollectionOfImpl()
    {
    }

    CollectionOfImpl( const CollectionOfImpl& /*copy*/ )
    {
    }

    virtual ~CollectionOfImpl();

    CollectionOfImpl& operator=( const CollectionOfImpl& /*copy*/ )
    {
	return *this;
    }

    virtual unsigned int getSize() const = 0;

    virtual void  add( void* element ) = 0;
    virtual void  removeAll() = 0;
    virtual CollectionOfImpl* createClone() const = 0;

    virtual IteratorOverImpl* createIterator() = 0;
};

class RealCollectionOfImpl : public  CollectionOfImpl
{
  public:
    RealCollectionOfImpl();
    RealCollectionOfImpl( const RealCollectionOfImpl& copy );
    
    virtual ~RealCollectionOfImpl();  

    RealCollectionOfImpl& operator=( const RealCollectionOfImpl& copy );

    virtual unsigned int getSize() const;

    virtual void  add( void* element );
    virtual void  removeAll();

    virtual IteratorOverImpl* createIterator();

    virtual CollectionOfImpl* createClone() const;

    void remove( DLink* adoptedElement );  
    DLink* getNext( DLink* link );
    DLink* getPrev( DLink* link );
    DLink* getFirst();

    DLink* getLast();

    bool isEnd( DLink* link )
    {
	return (link == _anchor);
    }

    void* getData( DLink* link );

    void insertBefore( DLink* link, void* element );
    void insertAfter( DLink* link, void* element );

    void copyFrom( const RealCollectionOfImpl& copy );

    DLink*    _anchor;  // _next is head, _prev is tail.
    unsigned int _count;
};

class OrderedCollectionOfImpl : public RealCollectionOfImpl 
{
  public:
    OrderedCollectionOfImpl();
    OrderedCollectionOfImpl( const OrderedCollectionOfImpl& copy );
    
    virtual ~OrderedCollectionOfImpl();  

    OrderedCollectionOfImpl& operator=( const OrderedCollectionOfImpl& copy );

    virtual CollectionOfImpl* createClone() const;

    virtual void  append( void* element );
    virtual void  prepend( void* element );
};

class IteratorOverImpl {
  public:
    IteratorOverImpl( CollectionOfImpl* collection )
	: _collection( collection )
	{
	}

    virtual ~IteratorOverImpl();

    virtual void* getFirst() = 0;
    virtual void* getLast() = 0;
    virtual void* getNext() = 0;
    virtual void* getPrev() = 0;

    virtual void  reset() = 0;
    virtual void  resetToEnd() = 0;
    virtual void* operator()( int skipBy ) = 0;
    virtual void* operator()() = 0;

    virtual void* remove() = 0;
    virtual void  insertAfter( void* element ) = 0;
    virtual void  insertBefore( void* element ) = 0;

    CollectionOfImpl* _collection;
};

class IteratorOverDLinkImpl : public IteratorOverImpl {
  public:
    IteratorOverDLinkImpl( CollectionOfImpl* collection )
	: IteratorOverImpl( collection ), _point(NULL), _justRemoved(false)
	{
	}

    virtual ~IteratorOverDLinkImpl();

    void* getFirst();
    void* getLast();
    void* getNext();
    void* getPrev();

    void  reset();
    void  resetToEnd();
    void* operator()( int skipBy );
    void* operator()();

    void* remove();
    void  insertAfter( void* element );
    void  insertBefore( void* element );

    DLink* _point;
    bool _justRemoved;
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_COLLECTIONS_I_H
