#ifndef _SYSADM_DICTIONARY_OF_I_H
#define _SYSADM_DICTIONARY_OF_I_H

/*
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

BEGIN_NAMESPACE(sysadm);

template <class Type> inline
DictionaryOf<Type>::DictionaryOf(unsigned int buckets)
: _templ(new DictionaryOfTempl(buckets))
{
}

template <class Type> inline
DictionaryOf<Type>::DictionaryOf(const DictionaryOf<Type> & copy)
: _templ(new DictionaryOfTempl(*copy._templ))
{
}

template <class Type> inline
DictionaryOf<Type>::~DictionaryOf(void)
{
    delete _templ;
}

template <class Type>  inline DictionaryOf<Type> &
DictionaryOf<Type>::operator=(const DictionaryOf<Type> & copy)
{
    if( this != &copy )
	*_templ = *copy._templ;

    return(*this);
}

template <class Type>  inline void
DictionaryOf<Type>::add(Type * element, Hashable * key)
{
    _templ->add((void*)element, key);
}

template <class Type>  inline Type *
DictionaryOf<Type>::remove(const Hashable & key)
{
    return((Type *)_templ->remove(key));
}

template <class Type>  inline Type *
DictionaryOf<Type>::lookupByKey(const Hashable & key,
				   const Hashable** retKey)
{
    return((Type *)_templ->lookupByKey(key, retKey));
}

template <class Type>  inline const Type *
DictionaryOf<Type>::lookupByKey(const Hashable & key,
				   const Hashable** retKey) const
{
    return((Type *)_templ->lookupByKey(key, retKey));
}

template <class Type>  inline Type *
DictionaryOf<Type>::operator[](const Hashable & key)
{
    return((Type *)(*_templ)[key]);
}

template <class Type>  inline const Type *
DictionaryOf<Type>::operator[](const Hashable & key) const
{
    return((const Type *)(*_templ)[key]);
}

template <class Type>  inline unsigned int
DictionaryOf<Type>::getSize() const
{
    return(_templ->getSize());
}

template <class Type> inline unsigned int
DictionaryOf<Type>::getBucketOverflow() const
{
    return(_templ->getBucketOverflow());
}

template <class Type> inline unsigned int
DictionaryOf<Type>::getMaxChain() const
{
    return(_templ->getMaxChain());
}

template <class Type> inline
ConstDictionaryOfIterator<Type>::
ConstDictionaryOfIterator(const DictionaryOf<Type> * dict)
: _templ(new DictionaryOfTemplIterator(dict->_templ))
{
}

template <class Type> inline
ConstDictionaryOfIterator<Type>::~ConstDictionaryOfIterator(void)
{
    delete _templ;
}

template <class Type>  inline void
ConstDictionaryOfIterator<Type>::reset(void)
{
    _templ->reset();
}

template <class Type>  inline Type *
ConstDictionaryOfIterator<Type>::operator()(void)
{
    return ((Type *)((*_templ)()));
}

template <class Type>  inline const Hashable *
ConstDictionaryOfIterator<Type>::key(void)
{
    return (_templ->key());
}

template <class Type>  inline DictionaryOfTemplIterator *
ConstDictionaryOfIterator<Type>::getImpl()
{
    return _templ;
}

template <class Type> inline
DictionaryOfIterator<Type>::
DictionaryOfIterator(DictionaryOf<Type> * dict)
: ConstDictionaryOfIterator<Type>(dict)
{
}

template <class Type>  inline Type *
DictionaryOfIterator<Type>::remove(void)
{
    return((Type *)getImpl()->remove());
}

template <class Type> inline
void RemoveAndDestroyContentsOf( DictionaryOf<Type> *dictAlias )
{
    DictionaryOfIterator<Type> iter(dictAlias);

    while (iter() != NULL) {
	delete iter.remove();
    }
}

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_DICTIONARY_OF_I_H
