#ifndef _SYSADM_DICTIONARY_OF_TEMPL_H
#define _SYSADM_DICTIONARY_OF_TEMPL_H

/*
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#include <sysadm/sysadm.h>
#include <stdio.h>

BEGIN_NAMESPACE(sysadm);

class DictionaryOfImpl;

class DictionaryOfTemplIterator;
class DictionaryOfTImpl;

class DictionaryOfTempl
{
  public:
    DictionaryOfTempl(unsigned int buckets = 251);
    DictionaryOfTempl(const DictionaryOfTempl& copy);
    
    ~DictionaryOfTempl(void);  

    DictionaryOfTempl& operator=(const DictionaryOfTempl& copy);

    void  add(void* element, Hashable * key);
    void* remove(const Hashable& key);  // requires operator==()

    void* lookupByKey(const Hashable & key,
		      const Hashable** retKey = NULL);
    const void* lookupByKey(const Hashable & key,
			    const Hashable** retKey = NULL) const;

    void* operator[](const Hashable& key);
    const void* operator[](const Hashable& key) const;

    unsigned int getSize() const;
    unsigned int getBucketOverflow() const;
    unsigned int getMaxChain() const;

  private:
    friend class DictionaryOfTemplIterator;
    friend class DictionaryOfTImpl;

    DictionaryOfImpl *	_impl;
};

class DictionaryOfTemplIterator {
  public:
    DictionaryOfTemplIterator(DictionaryOfTempl * dict);
    ~DictionaryOfTemplIterator(void);

    void reset(void);
    void * operator()(void);

    Hashable * key(void);

    void * remove(void);

  private:
    DictionaryOfTImpl *	_impl;
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_DICTIONARY_OF_TEMPL_H
