/*
 *  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ifndef _SYSADM_HASHABLE_H
#define _SYSADM_HASHABLE_H

#include <sysadm/sysadm.h>

BEGIN_NAMESPACE(sysadm);

typedef unsigned long HashValue;

class Hashable {
  public:
    inline virtual ~Hashable(void);

    virtual bool operator==(const Hashable & other) const = 0;
    virtual bool operator!=(const Hashable & other) const = 0;

    virtual HashValue getHashValue(void) const = 0;

    virtual Hashable* clone() const = 0;

  protected:
    inline Hashable(void);
    virtual void doNothing(); // makes sure vtbl gets put in right place
    Hashable(const Hashable & copy);
    Hashable & operator=(const Hashable & copy);
};

class PointerKey : public Hashable {
  public:

    inline PointerKey(void* key);
    inline virtual ~PointerKey(void);

    virtual bool operator==(const Hashable & other) const;
    virtual bool operator!=(const Hashable & other) const;

    inline virtual HashValue getHashValue(void) const;

    inline virtual Hashable* clone() const;

  private:
    void* _key;
};

END_NAMESPACE(sysadm);

#include <sysadm/HashableI.h>
#endif  //  _SYSADM_HASHABLE_H
