//
// LogFilter.h
//
//	Filter for log messages.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ifndef _SYSADM_LOG_FILTER_H
#define _SYSADM_LOG_FILTER_H
#ident "$Revision: 1.3 $"

#include <sysadm/Log.h>
#include <sysadm/String.h>
#include <sysadm/CollectionOf.h>

BEGIN_NAMESPACE(sysadm);

//
// LogFilter filters a message based on level and module.  A
// LogFilter has one level and a list of modules.  testMessage()
// returns true if "level" is set in the level mask for this filter,
// and if module is in our list of modules.   An empty list of
// modules means that messages from all modules are logged.
//
class LogFilter {
  public:

    // Constructor.
    LogFilter();

    // Destructor.
    virtual ~LogFilter();

    // Turn a level on for the purposes of this filter.  "level" can
    // be a single Log::Level or a combination (via bitwise or).
    virtual void levelOn(int level);

    // Turn a level off for the purposes of this filter.
    virtual void levelOff(int level);

    // Add a module to the list of modules for this filter.  If
    // our list of modules is non-empty, then only messages from
    // one of the modules in our list will be logged.
    virtual void addModule(const String& module);

    // Add each module in a comma-separated list of modules to our
    // list.
    virtual void addModuleList(const String& moduleList);

    // Remove a module from our list of modules.
    virtual void removeModule(const String& module);

    // Test whether a message should be logged, using our level and
    // module list as the criteria.  "module" is not a String to avoid
    // an unnecessary strdup().
    virtual bool testMessage(const char* module, Log::Level level);

  protected:

    int _levelMask;
    CollectionOf<String> _modules;

  private:

    // Intentionally undefined.
    LogFilter(const LogFilter&);
    LogFilter& operator=(const LogFilter&);
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_LOG_FILTER_H
